/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.text.ParseException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.infra.utils.DateUtils;
import org.egov.lcms.transactions.entity.Hearings;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.service.HearingsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hearing"})
public class EditHearingsController {
    @Autowired
    private HearingsService hearingsService;

    @RequestMapping(value={"/edit/{hearingsId}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="hearingsId") String hearingsId, Model model) {
        Hearings hearings = this.hearingsService.findById(Long.valueOf(Long.parseLong(hearingsId)));
        model.addAttribute("legalCase", (Object)hearings.getLegalCase());
        model.addAttribute("hearings", (Object)hearings);
        model.addAttribute("mode", (Object)"edit");
        return "hearings-edit";
    }

    @RequestMapping(value={"/edit/{hearingsId}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="hearingsId") String hearingsId, @Valid @ModelAttribute Hearings hearings, BindingResult errors, Model model, RedirectAttributes redirectAttrs, HttpServletRequest request) throws ParseException {
        LegalCase legalcase = hearings.getLegalCase();
        if (!DateUtils.compareDates((Date)hearings.getHearingDate(), (Date)hearings.getLegalCase().getCaseDate())) {
            errors.rejectValue("hearingDate", "ValidateDate.hearing.casedate");
        }
        hearings.setLegalCase(legalcase);
        if (errors.hasErrors()) {
            model.addAttribute("legalCase", (Object)legalcase);
            model.addAttribute("hearings", (Object)hearings);
            return "hearings-edit";
        }
        this.hearingsService.persist(hearings);
        redirectAttrs.addFlashAttribute("hearings", (Object)hearings);
        model.addAttribute("mode", (Object)"edit");
        model.addAttribute("message", (Object)"Hearing updated successfully.");
        return "hearings-success";
    }
}

