/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.reports;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.utils.JsonUtils;
import org.egov.lcms.reports.entity.LegalCommonReportResult;
import org.egov.lcms.reports.entity.TimeSeriesReportResult;
import org.egov.lcms.transactions.service.LegalCommonReportService;
import org.egov.lcms.transactions.service.TimeSeriesReportService;
import org.egov.lcms.web.adaptor.TimeSeriesReportJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/timeseriesreports"})
public class TimeSeriesReportController {
    @Autowired
    private TimeSeriesReportService timeSeriesReportService;
    @Autowired
    private LegalCommonReportService legalCommonReportService;

    @ModelAttribute(value="aggregatedByList")
    public List<String> getAggregatedBy() {
        ArrayList<String> aggregatedByList = new ArrayList<String>();
        aggregatedByList.add("Court Name");
        aggregatedByList.add("Petition Type");
        aggregatedByList.add("Case Status");
        aggregatedByList.add("Case Category");
        aggregatedByList.add("Court Type");
        aggregatedByList.add("In charge officer");
        aggregatedByList.add("Standing Counsel");
        return aggregatedByList;
    }

    @ModelAttribute(value="period")
    public List<String> getPeriod() {
        ArrayList<String> period = new ArrayList<String>();
        period.add("Year");
        period.add("Month");
        return period;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/timeSeriesReport"})
    public String searchForm(Model model) {
        model.addAttribute("timeSeriesReportResult", (Object)new TimeSeriesReportResult());
        model.addAttribute("currentDate", (Object)new Date());
        return "timeseriesreport-form";
    }

    @RequestMapping(value={"/timeSeriesReportresults"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getTimeSeriesReportResult(@ModelAttribute TimeSeriesReportResult timeSeriesReport, HttpServletRequest request) throws ParseException {
        List timeSeriesReportList = this.timeSeriesReportService.getTimeSeriesReportsResults(timeSeriesReport);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)timeSeriesReportList, TimeSeriesReportResult.class, TimeSeriesReportJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/drilldownreportresult"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<LegalCommonReportResult> getDrillDownReportResult(@ModelAttribute LegalCommonReportResult legalCommonReportObj, HttpServletRequest request) throws ParseException {
        return this.legalCommonReportService.getLegalCommonReportsResults(legalCommonReportObj, null);
    }
}

