/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.ajax;

import java.util.ArrayList;
import java.util.List;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.lcms.masters.entity.AdvocateMaster;
import org.egov.lcms.masters.entity.CourtMaster;
import org.egov.lcms.masters.entity.PetitionTypeMaster;
import org.egov.lcms.masters.service.AdvocateMasterService;
import org.egov.lcms.masters.service.CourtMasterService;
import org.egov.lcms.masters.service.CourtTypeMasterService;
import org.egov.lcms.masters.service.PetitionTypeMasterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/legalcase/"})
public class AjaxLegalCaseController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private AdvocateMasterService advocateMasterService;
    @Autowired
    private PetitionTypeMasterService petitiontypeMasterService;
    @Autowired
    private CourtTypeMasterService courtTypeMasterService;
    @Autowired
    private CourtMasterService courtMasterService;

    @RequestMapping(value={"ajax/departments"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Department> getAllDepartmentsByNameLike(@ModelAttribute(value="legalcase") @RequestParam String departmentName) {
        return this.departmentService.getAllDepartmentsByNameLike(departmentName);
    }

    @RequestMapping(value={"ajax/advocateSearch"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<AdvocateMaster> getAllAdvocatesByNameLike(@ModelAttribute(value="legalcase") @RequestParam String advocateName, @RequestParam Boolean isSeniorAdvocate) {
        return this.advocateMasterService.getAllAdvocatesByNameLikeAndIsSeniorAdvocate(advocateName.toUpperCase(), isSeniorAdvocate);
    }

    @RequestMapping(value={"/ajax-petitionTypeByCourtType"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<PetitionTypeMaster> getAllPetitionTypesByCountType(@RequestParam Long courtType) {
        List<Object> petitionTypeList = new ArrayList<PetitionTypeMaster>(0);
        if (courtType != null) {
            petitionTypeList = this.petitiontypeMasterService.findActivePetitionByCourtType(this.courtTypeMasterService.findOne(courtType));
            petitionTypeList.forEach(petitionType -> petitionType.toString());
        }
        return petitionTypeList;
    }

    @RequestMapping(value={"/ajax-courtNameByCourtType"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<CourtMaster> getAllCourtNamesByCountType(@RequestParam Long courtType) {
        List<Object> courtNameList = new ArrayList<CourtMaster>(0);
        if (courtType != null) {
            courtNameList = this.courtMasterService.findActiveCourtByCourtType(this.courtTypeMasterService.findOne(courtType));
            courtNameList.forEach(petitionType -> petitionType.toString());
        }
        return courtNameList;
    }
}

