/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.transactions.entity.BipartisanDetails;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseAdvocate;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/standingCouncil"})
public class StandingCouncilController {
    @Autowired
    private LegalCaseService legalCaseService;

    @RequestMapping(value={"/create/"}, method={RequestMethod.GET})
    public String viewForm(@ModelAttribute(value="legalCaseAdvocate") LegalCaseAdvocate legalCaseAdvocate, @RequestParam(value="lcNumber") String lcNumber, Model model, HttpServletRequest request) {
        LegalCase legalCase = this.getLegalCase(lcNumber);
        List legalAdvocateList = this.getLegalCase(lcNumber).getLegalCaseAdvocates();
        if (!legalAdvocateList.isEmpty()) {
            legalCaseAdvocate = (LegalCaseAdvocate)legalAdvocateList.get(0);
        }
        model.addAttribute("legalCase", (Object)legalCase);
        model.addAttribute("seniourAdvisRequired", (Object)legalCase.getIsSenioradvrequired());
        model.addAttribute("legalCaseAdvocate", (Object)legalCaseAdvocate);
        return "legalcase-standingCouncil";
    }

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber) {
        LegalCase legalcase = this.legalCaseService.findByLcNumber(lcNumber);
        return legalcase;
    }

    @RequestMapping(value={"/create/"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute(value="legalCaseAdvocate") LegalCaseAdvocate legalCaseAdvocate, BindingResult errors, RedirectAttributes redirectAttrs, @RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request, Model model) throws ParseException {
        LegalCase legalCase = this.getLegalCase(lcNumber);
        if (errors.hasErrors()) {
            model.addAttribute("legalcase", (Object)legalCase);
            return "legalcase-standingCouncil";
        }
        legalCaseAdvocate.setLegalCase(legalCase);
        this.legalCaseService.saveStandingCouncilEntity(legalCaseAdvocate);
        redirectAttrs.addFlashAttribute("legalCaseAdvocate", (Object)legalCaseAdvocate);
        model.addAttribute("message", (Object)"Standing Council Saved successfully.");
        model.addAttribute("legalcase", (Object)legalCase);
        model.addAttribute("legalCaseAdvocate", (Object)legalCaseAdvocate);
        ArrayList<BipartisanDetails> pettempList = new ArrayList<BipartisanDetails>();
        ArrayList<BipartisanDetails> respoTempList = new ArrayList<BipartisanDetails>();
        for (BipartisanDetails dd : legalCase.getBipartisanDetails()) {
            if (dd.getIsRepondent().booleanValue()) {
                pettempList.add(dd);
                continue;
            }
            respoTempList.add(dd);
        }
        model.addAttribute("mode", (Object)"view");
        model.addAttribute("pettempList", pettempList);
        model.addAttribute("respoTempList", respoTempList);
        return "legalcasedetails-view";
    }
}

