/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.io.IOException;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.masters.service.JudgmentTypeService;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.service.JudgmentService;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/judgment"})
public class JudgmentController {
    @Autowired
    private JudgmentTypeService judgmentTypeService;
    @Autowired
    private LegalCaseService legalcaseService;
    @Autowired
    private JudgmentService judgmentService;

    private void prepareNewForm(Model model) {
        model.addAttribute("judgmentTypes", (Object)this.judgmentTypeService.getActiveJudgementTypes());
    }

    @RequestMapping(value={"/new/"}, method={RequestMethod.GET})
    public String viewForm(@ModelAttribute(value="judgment") Judgment judgment, @RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request, Model model) {
        this.prepareNewForm(model);
        LegalCase legalCase = this.getLegalCase(lcNumber, request);
        model.addAttribute("legalCase", (Object)legalCase);
        model.addAttribute("judgment", (Object)judgment);
        model.addAttribute("mode", (Object)"create");
        return "judgment-new";
    }

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request) {
        LegalCase legalCase = this.legalcaseService.findByLcNumber(lcNumber);
        return legalCase;
    }

    @RequestMapping(value={"/new/"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute(value="judgment") Judgment judgment, BindingResult errors, RedirectAttributes redirectAttrs, @RequestParam(value="lcNumber") String lcNumber, @RequestParam(value="file") MultipartFile[] files, HttpServletRequest request, Model model) throws IOException, ParseException {
        LegalCase legalcase = this.getLegalCase(lcNumber, request);
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            model.addAttribute("legalcase", (Object)legalcase);
            return "judgment-new";
        }
        judgment.setLegalCase(legalcase);
        this.judgmentService.persist(judgment, files);
        model.addAttribute("mode", (Object)"view");
        redirectAttrs.addFlashAttribute("judgment", (Object)judgment);
        model.addAttribute("message", (Object)"Judgment Created successfully.");
        return "judgment-success";
    }
}

