/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.masters.service.JudgmentTypeService;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.service.JudgmentService;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/judgment"})
public class EditJudgmentController {
    @Autowired
    private JudgmentTypeService judgmentTypeService;
    @Autowired
    private LegalCaseService legalCaseService;
    @Autowired
    private JudgmentService judgmentService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        return legalCase;
    }

    private void prepareNewForm(Model model) {
        model.addAttribute("judgmentTypes", (Object)this.judgmentTypeService.findAll());
    }

    @RequestMapping(value={"/edit/"}, method={RequestMethod.GET})
    public String edit(@RequestParam(value="lcNumber") String lcNumber, Model model) {
        List judgementList = this.getLegalCase(lcNumber).getJudgment();
        Judgment judgmentObj = (Judgment)judgementList.get(0);
        this.prepareNewForm(model);
        model.addAttribute("judgment", (Object)judgmentObj);
        this.getJudgmentDocuments(judgmentObj);
        model.addAttribute("mode", (Object)"edit");
        return "judgment-edit";
    }

    @RequestMapping(value={"/edit/"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Judgment judgment, @RequestParam(value="lcNumber") String lcNumber, BindingResult errors, @RequestParam(value="file") MultipartFile[] files, HttpServletRequest request, Model model, RedirectAttributes redirectAttrs) throws IOException, ParseException {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return "judgment-edit";
        }
        this.judgmentService.persist(judgment, files);
        this.getJudgmentDocuments(judgment);
        redirectAttrs.addFlashAttribute("judgment", (Object)judgment);
        model.addAttribute("message", (Object)"Judgment updated successfully.");
        model.addAttribute("mode", (Object)"view");
        return "judgment-success";
    }

    private Judgment getJudgmentDocuments(Judgment judgment) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.legalCaseUtil.getJudgmentDocumentList(judgment);
        judgment.setJudgmentDocuments(documentDetailsList);
        return judgment;
    }
}

