/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.reports;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.lcms.entity.es.LegalCaseDocument;
import org.egov.lcms.reports.entity.DailyBoardReportResults;
import org.egov.lcms.repository.es.LegalCaseDocumentRepository;
import org.egov.lcms.web.controller.transactions.GenericLegalCaseController;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class DailyBoardReportsController
extends GenericLegalCaseController {
    @Autowired
    private LegalCaseDocumentRepository legalCaseDocumentRepository;

    @RequestMapping(method={RequestMethod.GET}, value={"/dailyBoardReport"})
    public String searchForm(Model model) {
        model.addAttribute("dailyBoardReportResult", (Object)new DailyBoardReportResults());
        model.addAttribute("currentDate", (Object)new Date());
        return "dailyboardreport-form";
    }

    @RequestMapping(value={"/dailyBoardReportresults"}, method={RequestMethod.POST})
    @ResponseBody
    public List<DailyBoardReportResults> getDailyBoardReport(@ModelAttribute DailyBoardReportResults dailyBoardReport) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
        SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
        ArrayList<DailyBoardReportResults> finalResult = new ArrayList<DailyBoardReportResults>();
        List legalcaseDocumentTempList = this.findAllLegalcaseDocumentIndexByFilter(dailyBoardReport);
        for (LegalCaseDocument legalcaseDocumentIndex : legalcaseDocumentTempList) {
            DailyBoardReportResults dailyBoardReportResultObj = new DailyBoardReportResults();
            dailyBoardReportResultObj.setLcNumber(legalcaseDocumentIndex.getLcNumber());
            dailyBoardReportResultObj.setCaseTitle(legalcaseDocumentIndex.getCaseTitle());
            dailyBoardReportResultObj.setCourtName(legalcaseDocumentIndex.getCourtName());
            dailyBoardReportResultObj.setCaseNumber(legalcaseDocumentIndex.getCaseNumber());
            dailyBoardReportResultObj.setPetitionerName(legalcaseDocumentIndex.getPetitionerNames());
            dailyBoardReportResultObj.setRespondantName(legalcaseDocumentIndex.getRespondantNames());
            dailyBoardReportResultObj.setPetitionType(legalcaseDocumentIndex.getPetitionType());
            dailyBoardReportResultObj.setStandingCouncil(legalcaseDocumentIndex.getAdvocateName());
            dailyBoardReportResultObj.setOfficerIncharge(legalcaseDocumentIndex.getOfficerIncharge());
            dailyBoardReportResultObj.setCaseStatus(legalcaseDocumentIndex.getStatus());
            dailyBoardReportResultObj.setNextDate(myFormat.format(dateFormat.parse(legalcaseDocumentIndex.getNextDate().toString())));
            finalResult.add(dailyBoardReportResultObj);
        }
        return finalResult;
    }

    public List<LegalCaseDocument> findAllLegalcaseDocumentIndexByFilter(DailyBoardReportResults dailyBoardReport) throws ParseException {
        BoolQueryBuilder query = this.getFilterQuery(dailyBoardReport);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"legalcasedocument"}).withQuery((QueryBuilder)query).withPageable((Pageable)new PageRequest(0, 250)).build();
        Page legalcaseDocumentSearchList = this.legalCaseDocumentRepository.search((SearchQuery)searchQuery);
        ArrayList<LegalCaseDocument> legalcaseDocumentList = new ArrayList<LegalCaseDocument>();
        for (LegalCaseDocument documentObj : legalcaseDocumentSearchList) {
            legalcaseDocumentList.add(documentObj);
        }
        return legalcaseDocumentList;
    }

    private BoolQueryBuilder getFilterQuery(DailyBoardReportResults searchRequest) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat newFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"cityName", (String)ApplicationThreadLocals.getCityName()));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getFromDate())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"caseDate").gte(newFormat.format(formatter.parse(searchRequest.getFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getToDate())))));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseCategory())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"caseType", (Object)searchRequest.getCaseCategory()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getOfficerIncharge())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"officerIncharge", (String)searchRequest.getOfficerIncharge().split("@")[0]));
        }
        return boolQuery;
    }
}

