/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.egov.lcms.masters.service.CourtMasterService;
import org.egov.lcms.masters.service.PetitionTypeMasterService;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.egov.lcms.web.controller.transactions.GenericLegalCaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application/"})
public class ViewAndEditLegalCaseController
extends GenericLegalCaseController {
    @Autowired
    private LegalCaseService legalCaseService;
    @Autowired
    private PetitionTypeMasterService petitiontypeMasterService;
    @Autowired
    private CourtMasterService courtMasterService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        return legalCase;
    }

    @RequestMapping(value={"/view/"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="lcNumber") String lcNumber, Model model) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        LegalCase newlegalCase = this.getLegalCaseDocuments(legalCase);
        model.addAttribute("legalCase", (Object)newlegalCase);
        model.addAttribute("mode", (Object)"view");
        return "legalcasedetails-view";
    }

    @RequestMapping(value={"/edit/"}, method={RequestMethod.GET})
    public String edit(@RequestParam(value="lcNumber") String lcNumber, Model model) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        LegalCase newlegalCase = this.getLegalCaseDocuments(legalCase);
        model.addAttribute("legalCase", (Object)newlegalCase);
        this.setDropDownValues(model);
        String[] casenumberyear = legalCase.getCaseNumber().split("/");
        legalCase.setCaseNumber(casenumberyear[0]);
        if (casenumberyear.length > 1) {
            legalCase.setWpYear(casenumberyear[1]);
        }
        legalCase.getBipartisanPetitionerDetailsList().addAll(legalCase.getPetitioners());
        legalCase.getBipartisanRespondentDetailsList().addAll(legalCase.getRespondents());
        model.addAttribute("mode", (Object)"edit");
        return "legalcase-edit";
    }

    @RequestMapping(value={"/edit/"}, method={RequestMethod.POST})
    public String update(@ModelAttribute LegalCase legalCase, @RequestParam(value="lcNumber") String lcNumber, BindingResult errors, @RequestParam(value="file") MultipartFile[] files, Model model, RedirectAttributes redirectAttrs) throws IOException, ParseException {
        if (errors.hasErrors()) {
            return "legalcase-edit";
        }
        this.legalCaseService.persist(legalCase, files);
        this.setDropDownValues(model);
        LegalCase newlegalCase = this.getLegalCaseDocuments(legalCase);
        model.addAttribute("legalCase", (Object)newlegalCase);
        redirectAttrs.addFlashAttribute("legalCase", (Object)newlegalCase);
        model.addAttribute("mode", (Object)"view");
        model.addAttribute("message", (Object)"LegalCase updated successfully.");
        return "legalcase-success";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("courtsList", (Object)this.courtMasterService.findAll());
        model.addAttribute("petitiontypeList", (Object)this.petitiontypeMasterService.getPetitiontypeList());
    }

    private LegalCase getLegalCaseDocuments(LegalCase legalCase) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.legalCaseUtil.getLegalCaseDocumentList(legalCase);
        legalCase.setLegalCaseUploadDocuments(documentDetailsList);
        return legalCase;
    }
}

