/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.commons.EgwStatus;
import org.egov.infra.web.utils.WebUtils;
import org.egov.lcms.reports.entity.LegalCaseSearchResult;
import org.egov.lcms.transactions.service.SearchLegalCaseService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.egov.lcms.web.adaptor.LegalCaseSearchJsonAdaptor;
import org.egov.lcms.web.controller.transactions.GenericLegalCaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/search"})
public class LegalCaseSearchController
extends GenericLegalCaseController {
    @Autowired
    private SearchLegalCaseService searchLegalCaseService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @ModelAttribute
    private void getLegalCaseReport(Model model) {
        LegalCaseSearchResult legalCaseReportResult = new LegalCaseSearchResult();
        model.addAttribute("legalCaseReportResult", (Object)legalCaseReportResult);
    }

    @ModelAttribute(value="statusList")
    public List<EgwStatus> getStatusList() {
        return this.legalCaseUtil.getStatusForModule();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/searchForm"})
    public String saechForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        return "search-legalCaseForm";
    }

    @ExceptionHandler(value={Exception.class})
    @RequestMapping(value={"/legalsearchResult"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getLegalCaseSearchResult(@RequestParam String caseNumber, @RequestParam String lcNumber, @RequestParam Integer court, @RequestParam Integer caseType, @RequestParam String standingCouncil, @RequestParam Integer courtType, @RequestParam Date caseFromDate, @RequestParam Date caseToDate, @RequestParam Integer caseStatus, @RequestParam Integer petionType, @RequestParam String isStatusExcluded, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Boolean caseExcluded = Boolean.FALSE;
        if (request.getParameter("isStatusExcluded").equals("true")) {
            caseExcluded = Boolean.TRUE;
        }
        LegalCaseSearchResult legalCaseSearchResultOblj = new LegalCaseSearchResult();
        legalCaseSearchResultOblj.setCaseNumber(caseNumber);
        legalCaseSearchResultOblj.setLcNumber(lcNumber);
        legalCaseSearchResultOblj.setCourtId(court);
        legalCaseSearchResultOblj.setCasecategory(caseType);
        legalCaseSearchResultOblj.setCourtType(courtType);
        legalCaseSearchResultOblj.setStandingCouncil(standingCouncil);
        legalCaseSearchResultOblj.setCaseFromDate(caseFromDate);
        legalCaseSearchResultOblj.setStatusId(caseStatus);
        legalCaseSearchResultOblj.setPetitionTypeId(petionType);
        List legalcaseSearchList = this.searchLegalCaseService.getLegalCaseReport(legalCaseSearchResultOblj, caseExcluded);
        String result = "{ \"data\":" + WebUtils.toJSON((Collection)legalcaseSearchList, LegalCaseSearchResult.class, LegalCaseSearchJsonAdaptor.class) + "}";
        return result;
    }
}

