/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseDisposal;
import org.egov.lcms.transactions.service.LegalCaseDisposalService;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/legalcasedisposal"})
public class LegalCaseDisposalController {
    @Autowired
    private LegalCaseDisposalService legalCaseDisposalService;
    @Autowired
    private LegalCaseService legalCaseService;

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        return legalCase;
    }

    @RequestMapping(value={"/new/"}, method={RequestMethod.GET})
    public String newForm(@ModelAttribute LegalCaseDisposal legalCaseDisposal, Model model, @RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request) {
        LegalCase legalCase = this.getLegalCase(lcNumber);
        model.addAttribute("legalCase", (Object)legalCase);
        model.addAttribute("legalCaseDisposal", (Object)legalCaseDisposal);
        model.addAttribute("mode", (Object)"create");
        return "legalcaseDisposal-new";
    }

    @RequestMapping(value={"/new/"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute LegalCaseDisposal legalCaseDisposal, BindingResult errors, @RequestParam(value="lcNumber") String lcNumber, RedirectAttributes redirectAttrs, Model model, HttpServletRequest request) {
        LegalCase legalCase = this.getLegalCase(lcNumber);
        if (errors.hasErrors()) {
            model.addAttribute("legalcase", (Object)legalCase);
            return "legalcaseDisposal-new";
        }
        legalCaseDisposal.setLegalCase(legalCase);
        this.legalCaseDisposalService.persist(legalCaseDisposal);
        redirectAttrs.addFlashAttribute("legalCaseDisposal", (Object)legalCaseDisposal);
        model.addAttribute("message", (Object)"Case is closed successfully.");
        model.addAttribute("mode", (Object)"create");
        return "legalcaseDisposal-success";
    }
}

