/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.egov.lcms.transactions.service.JudgmentImplService;
import org.egov.lcms.transactions.service.JudgmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/judgmentimpl"})
public class JudgmentImplController {
    @Autowired
    private JudgmentImplService judgmentImplService;
    @Autowired
    private JudgmentService judgmentService;

    @ModelAttribute
    private JudgmentImpl getJudgment(@RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request) {
        Judgment judgment = this.judgmentService.findByLcNumber(lcNumber);
        if (judgment.getJudgmentImpl().isEmpty()) {
            JudgmentImpl judgemnetImpl = new JudgmentImpl();
            return judgemnetImpl;
        }
        return (JudgmentImpl)judgment.getJudgmentImpl().get(0);
    }

    @RequestMapping(value={"/new/"}, method={RequestMethod.GET})
    public String viewForm(@ModelAttribute(value="judgmentImpl") JudgmentImpl judgmentImpl, @RequestParam(value="lcNumber") String lcNumber, Model model, HttpServletRequest request) {
        Judgment judgment = this.judgmentService.findByLcNumber(lcNumber);
        judgmentImpl = this.getJudgment(lcNumber, request);
        model.addAttribute("legalCase", (Object)judgment.getLegalCase());
        model.addAttribute("judgmentImpl", (Object)judgmentImpl);
        model.addAttribute("judgment", (Object)judgment);
        model.addAttribute("mode", (Object)"create");
        return "judgmentimpl-new";
    }

    @RequestMapping(value={"/new/"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute(value="judgmentImpl") JudgmentImpl judgmentImpl, BindingResult errors, RedirectAttributes redirectAttrs, @RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request, Model model) {
        Judgment judgment = this.judgmentService.findByLcNumber(lcNumber);
        if (errors.hasErrors()) {
            model.addAttribute("judgment", (Object)judgment);
            model.addAttribute("legalCase", (Object)judgment.getLegalCase());
            return "judgmentimpl-new";
        }
        judgmentImpl.setJudgment(judgment);
        this.judgmentImplService.saveOrUpdate(judgmentImpl);
        model.addAttribute("mode", (Object)"create");
        model.addAttribute("appealDocList", (Object)this.judgmentImplService.getAppealDocList(judgmentImpl));
        redirectAttrs.addFlashAttribute("judgmentImpl", (Object)judgmentImpl);
        model.addAttribute("message", (Object)"Judgment Implementation Created successfully.");
        return "judgmentimpl-success";
    }
}

