/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.util.List;
import javax.validation.Valid;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseDisposal;
import org.egov.lcms.transactions.service.LegalCaseDisposalService;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/legalcasedisposal"})
public class EditLegalCaseDisposalController {
    @Autowired
    private LegalCaseDisposalService legalCaseDisposalService;
    @Autowired
    private LegalCaseService legalCaseService;

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        return legalCase;
    }

    @RequestMapping(value={"/edit/"}, method={RequestMethod.GET})
    public String edit(@RequestParam(value="lcNumber") String lcNumber, Model model) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        List legalCaseDisposalList = this.getLegalCase(lcNumber).getLegalcaseDisposal();
        LegalCaseDisposal legalCaseDisposalObj = (LegalCaseDisposal)legalCaseDisposalList.get(0);
        model.addAttribute("legalCase", (Object)legalCase);
        model.addAttribute("legalCaseDisposal", (Object)legalCaseDisposalObj);
        model.addAttribute("mode", (Object)"edit");
        return "legalcaseDisposal-edit";
    }

    @RequestMapping(value={"/edit/"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute LegalCaseDisposal legalCaseDisposal, @RequestParam(value="lcNumber") String lcNumber, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "legalcaseDisposal-edit";
        }
        this.legalCaseDisposalService.persist(legalCaseDisposal);
        redirectAttrs.addFlashAttribute("legalCaseDisposal", (Object)legalCaseDisposal);
        model.addAttribute("message", (Object)"Close Case updated successfully.");
        model.addAttribute("mode", (Object)"edit");
        return "legalcaseDisposal-success";
    }
}

