/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.transactions.entity.Hearings;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.service.HearingsService;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hearing"})
public class EditHearingsController {
    @Autowired
    private HearingsService hearingsService;
    @Autowired
    private LegalCaseService legalCaseService;

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        return legalCase;
    }

    @RequestMapping(value={"/edit/"}, method={RequestMethod.GET})
    public String edit(@RequestParam(value="lcNumber") String lcNumber, Model model) {
        LegalCase legalcase = this.legalCaseService.findByLcNumber(lcNumber);
        List hearingsList = legalcase.getHearings();
        Hearings hearingsObj = (Hearings)hearingsList.get(0);
        model.addAttribute("legalCase", (Object)legalcase);
        model.addAttribute("hearings", (Object)hearingsObj);
        model.addAttribute("mode", (Object)"edit");
        return "hearings-edit";
    }

    @RequestMapping(value={"/edit/"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Hearings hearings, @RequestParam(value="lcNumber") String lcNumber, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        LegalCase legalcase = this.legalCaseService.findByLcNumber(lcNumber);
        hearings.setLegalCase(legalcase);
        if (errors.hasErrors()) {
            model.addAttribute("legalCase", (Object)legalcase);
            model.addAttribute("hearings", (Object)hearings);
            return "hearings-edit";
        }
        this.hearingsService.persist(hearings);
        redirectAttrs.addFlashAttribute("hearings", (Object)hearings);
        model.addAttribute("mode", (Object)"edit");
        model.addAttribute("message", (Object)"Hearing updated successfully.");
        return "hearings-success";
    }
}

