/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.autonumber.LegalCaseNumberGenerator;
import org.egov.lcms.masters.entity.enums.LCNumberType;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.egov.lcms.web.controller.transactions.GenericLegalCaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application/"})
public class CreateLegalCaseController
extends GenericLegalCaseController {
    @Autowired
    private LegalCaseService legalCaseService;
    @Autowired
    private LegalCaseNumberGenerator legalCaseNumberGenerator;

    @RequestMapping(value={"create/"}, method={RequestMethod.GET})
    public String newForm(@ModelAttribute LegalCase legalcase, Model model, HttpServletRequest request) {
        model.addAttribute("legalcase", (Object)legalcase);
        model.addAttribute("mode", (Object)"create");
        return "legalCase-newForm";
    }

    @RequestMapping(value={"create/"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute LegalCase legalCase, BindingResult errors, RedirectAttributes redirectAttrs, Model model, HttpServletRequest request) {
        if (errors.hasErrors()) {
            model.addAttribute("legalcase", (Object)legalCase);
            model.addAttribute("mode", (Object)"create");
            model.addAttribute("bipartisanRespondentDetailsList", (Object)legalCase.getBipartisanRespondentDetailsList());
            model.addAttribute("bipartisanPetitionerDetailsList", (Object)legalCase.getBipartisanPetitionerDetailsList());
            return "legalCase-newForm";
        }
        if (legalCase.getLcNumberType() != null && legalCase.getLcNumberType().equals((Object)LCNumberType.AUTOMATED)) {
            legalCase.setLcNumber(this.legalCaseNumberGenerator.generateLegalCaseNumber());
        } else {
            legalCase.setLcnumber(legalCase.getLcNumber() + (legalCase.getFinwpYear() != null ? "/" + legalCase.getFinwpYear() : ""));
        }
        this.legalCaseService.persist(legalCase);
        redirectAttrs.addFlashAttribute("legalCase", (Object)legalCase);
        model.addAttribute("message", (Object)"Legal Case created successfully.");
        model.addAttribute("mode", (Object)"create");
        model.addAttribute("legalCaseDocList", (Object)this.legalCaseService.getLegalCaseDocList(legalCase));
        return "legalcase-success";
    }
}

