/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/counterAffidavit"})
public class CounterAffidavitController {
    @Autowired
    private LegalCaseService legalCaseService;

    @RequestMapping(value={"/create/"}, method={RequestMethod.GET})
    public String viewForm(@ModelAttribute(value="legalCase") LegalCase legalCase, @RequestParam(value="lcNumber") String lcNumber, Model model, HttpServletRequest request) {
        model.addAttribute("legalCase", (Object)legalCase);
        model.addAttribute("pwrDocList", (Object)this.legalCaseService.getPwrDocList(legalCase));
        return "legalcase-caaffidavit";
    }

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber) {
        LegalCase legalcase = this.legalCaseService.findByLcNumber(lcNumber);
        return legalcase;
    }

    @RequestMapping(value={"/create/"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute(value="legalCase") LegalCase legalCase, BindingResult errors, RedirectAttributes redirectAttrs, @RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("legalcase", (Object)legalCase);
            return "legalcase-caaffidavit";
        }
        this.legalCaseService.update(legalCase);
        redirectAttrs.addFlashAttribute("legalCase", (Object)legalCase);
        model.addAttribute("message", (Object)"LegalCase Updated successfully.");
        model.addAttribute("legalcase", (Object)legalCase);
        model.addAttribute("legalCaseDocList", (Object)this.legalCaseService.getLegalCaseDocList(legalCase));
        model.addAttribute("pwrDocList", (Object)this.legalCaseService.getPwrDocList(legalCase));
        model.addAttribute("mode", (Object)"view");
        return "legalcasedetails-view";
    }
}

