/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.masters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import org.egov.commons.Bank;
import org.egov.commons.Bankbranch;
import org.egov.commons.service.BankBranchService;
import org.egov.lcms.masters.entity.AdvocateMaster;
import org.egov.lcms.masters.service.AdvocateMasterService;
import org.egov.lcms.web.adaptor.AdvocateMasterJsonAdaptor;
import org.egov.services.masters.BankService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/advocatemaster"})
public class AdvocateMasterController {
    private static final String ADVOCATEMASTER_NEW = "advocatemaster-new";
    private static final String ADVOCATEMASTER_RESULT = "advocatemaster-result";
    private static final String ADVOCATEMASTER_EDIT = "advocatemaster-edit";
    private static final String ADVOCATEMASTER_VIEW = "advocatemaster-view";
    private static final String ADVOCATEMASTER_SEARCH = "advocatemaster-search";
    @Autowired
    @Qualifier(value="advocateMasterService")
    private AdvocateMasterService advocateMasterService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    @Qualifier(value="bankService")
    private BankService bankService;
    @Autowired
    @Qualifier(value="bankBranchService")
    private BankBranchService bankBranchService;

    private void prepareNewForm(Model model) {
        model.addAttribute("banks", (Object)this.bankService.findAll());
        model.addAttribute("bankbranchs", (Object)Collections.EMPTY_LIST);
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("advocateMaster", (Object)new AdvocateMaster());
        model.addAttribute("mode", (Object)"create");
        return ADVOCATEMASTER_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute AdvocateMaster advocateMaster, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return ADVOCATEMASTER_NEW;
        }
        if (advocateMaster.getBankName() != null && advocateMaster.getBankName().getId() != null) {
            advocateMaster.setBankName((Bank)this.bankService.findById((Serializable)advocateMaster.getBankName().getId(), false));
        } else {
            advocateMaster.setBankName(null);
        }
        if (advocateMaster.getBankBranch() != null && advocateMaster.getBankBranch().getId() != null) {
            advocateMaster.setBankBranch((Bankbranch)this.bankBranchService.findById((Serializable)advocateMaster.getBankBranch().getId(), false));
        } else {
            advocateMaster.setBankBranch(null);
        }
        this.advocateMasterService.persist(advocateMaster);
        this.advocateMasterService.createAccountDetailKey(advocateMaster);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.advocateMaster.success", null, null));
        return "redirect:/advocatemaster/result/" + advocateMaster.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        AdvocateMaster advocateMaster = this.advocateMasterService.findOne(id);
        model.addAttribute("mode", (Object)"edit");
        if (advocateMaster.getBankName() != null && advocateMaster.getBankBranch() != null) {
            Bankbranch bankbranch = (Bankbranch)this.bankBranchService.findById((Serializable)advocateMaster.getBankBranch().getId(), false);
            ArrayList<Bankbranch> bankbranchList = new ArrayList<Bankbranch>();
            bankbranchList.add(bankbranch);
            advocateMaster.setBankBranch(bankbranch);
            model.addAttribute("bankbranchlist", bankbranchList);
        }
        this.prepareNewForm(model);
        model.addAttribute("advocateMaster", (Object)advocateMaster);
        return ADVOCATEMASTER_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute AdvocateMaster advocateMaster, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return ADVOCATEMASTER_EDIT;
        }
        if (advocateMaster.getBankName() != null && advocateMaster.getBankName().getId() != null) {
            advocateMaster.setBankName((Bank)this.bankService.findById((Serializable)advocateMaster.getBankName().getId(), false));
        } else {
            advocateMaster.setBankName(null);
        }
        if (advocateMaster.getBankBranch() != null && advocateMaster.getBankBranch().getId() != null) {
            advocateMaster.setBankBranch((Bankbranch)this.bankBranchService.findById((Serializable)advocateMaster.getBankBranch().getId(), false));
        } else {
            advocateMaster.setBankBranch(null);
        }
        this.advocateMasterService.persist(advocateMaster);
        this.advocateMasterService.createAccountDetailKey(advocateMaster);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.advocateMaster.update", null, null));
        return "redirect:/advocatemaster/result/" + advocateMaster.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        AdvocateMaster advocateMaster = this.advocateMasterService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("advocateMaster", (Object)advocateMaster);
        return ADVOCATEMASTER_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        AdvocateMaster advocateMaster = this.advocateMasterService.findOne(id);
        model.addAttribute("advocateMaster", (Object)advocateMaster);
        return ADVOCATEMASTER_RESULT;
    }

    @ModelAttribute(value="paymentModeList")
    public List<String> modeOfPaymentList() {
        ArrayList<String> paymentModeList = new ArrayList<String>();
        paymentModeList.add("Cash");
        paymentModeList.add("Cheque");
        paymentModeList.add("RTGS");
        return paymentModeList;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        AdvocateMaster advocateMaster = new AdvocateMaster();
        this.prepareNewForm(model);
        model.addAttribute("advocateMaster", (Object)advocateMaster);
        return ADVOCATEMASTER_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute AdvocateMaster advocateMaster) {
        List searchResultList = this.advocateMasterService.search(advocateMaster);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(AdvocateMaster.class, (Object)new AdvocateMasterJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

