/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import org.egov.infra.utils.DateUtils;
import org.egov.lcms.reports.entity.DailyBoardReportResults;

public class DailyBoardReportJsonAdapter
implements JsonSerializer<DailyBoardReportResults> {
    public JsonElement serialize(DailyBoardReportResults dailyboardresult, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("caseNumber", dailyboardresult.getLegalCase().getCaseNumber());
        jsonObject.addProperty("caseTitle", dailyboardresult.getLegalCase().getCaseTitle());
        jsonObject.addProperty("courtName", dailyboardresult.getCourtName());
        jsonObject.addProperty("petitionType", dailyboardresult.getPetitionType());
        jsonObject.addProperty("petitioners", dailyboardresult.getLegalCase().getPetitionersNames());
        jsonObject.addProperty("respondants", dailyboardresult.getLegalCase().getRespondantNames());
        jsonObject.addProperty("standingCouncil", dailyboardresult.getLegalCase().getOppPartyAdvocate());
        jsonObject.addProperty("officerIncharge", dailyboardresult.getLegalCase().getOfficerIncharge());
        jsonObject.addProperty("caseStatus", dailyboardresult.getCaseStatus());
        jsonObject.addProperty("nextDate", dailyboardresult.getLegalCase().getNextDate() == null ? "" : DateUtils.getDefaultFormattedDate((Date)dailyboardresult.getLegalCase().getNextDate()));
        return jsonObject;
    }
}

