/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.reports;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.infra.web.utils.WebUtils;
import org.egov.lcms.reports.entity.DailyBoardReportResults;
import org.egov.lcms.transactions.service.DailyBoardReportService;
import org.egov.lcms.web.adaptor.DailyBoardReportJsonAdapter;
import org.egov.lcms.web.controller.transactions.GenericLegalCaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class DailyBoardReportsController
extends GenericLegalCaseController {
    @Autowired
    private DailyBoardReportService dailyBoardReportService;

    @ModelAttribute
    private void getDailyBoardReport(Model model) {
        DailyBoardReportResults dailyBoardReportResult = new DailyBoardReportResults();
        model.addAttribute("dailyBoardReportResult", (Object)dailyBoardReportResult);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/dailyBoardReport"})
    public String searchForm(Model model) {
        model.addAttribute("currentDate", (Object)new Date());
        return "dailyboardreport-form";
    }

    @ExceptionHandler(value={Exception.class})
    @RequestMapping(value={"/dailyBoardReportresults"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getDailyBoardReportResult(@RequestParam Integer caseType, @RequestParam Date fromDate, @RequestParam Date toDate, @RequestParam String officerIncharge, HttpServletRequest request, HttpServletResponse response) throws IOException {
        DailyBoardReportResults dailyBoardReportObj = new DailyBoardReportResults();
        dailyBoardReportObj.setCasecategory(caseType);
        dailyBoardReportObj.setOfficerIncharge(officerIncharge);
        dailyBoardReportObj.setFromDate(fromDate);
        dailyBoardReportObj.setToDate(toDate);
        List dailyBoardReportList = this.dailyBoardReportService.getDailyBoardReports(dailyBoardReportObj);
        String result = "{ \"data\":" + WebUtils.toJSON((Collection)dailyBoardReportList, DailyBoardReportResults.class, DailyBoardReportJsonAdapter.class) + "}";
        return result;
    }
}

