/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import org.egov.infra.utils.DateUtils;
import org.egov.lcms.reports.entity.DueReportResult;

public class DueReportResultJsonAdaptor
implements JsonSerializer<DueReportResult> {
    public JsonElement serialize(DueReportResult dueReportResult, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("caseNumber", dueReportResult.getLegalCase().getCaseNumber());
        jsonObject.addProperty("legalcaseno", dueReportResult.getLegalCase().getLcNumber());
        jsonObject.addProperty("caseTitle", dueReportResult.getLegalCase().getCaseTitle());
        jsonObject.addProperty("courtName", dueReportResult.getCourtName());
        jsonObject.addProperty("petitionType", dueReportResult.getPetitionType());
        jsonObject.addProperty("petitionerName", dueReportResult.getLegalCase().getPetitionersNames());
        jsonObject.addProperty("respondantName", dueReportResult.getLegalCase().getRespondantNames());
        jsonObject.addProperty("standingCouncil", dueReportResult.getLegalCase().getOppPartyAdvocate());
        jsonObject.addProperty("officerIncharge", dueReportResult.getLegalCase().getOfficerIncharge());
        if (dueReportResult.getHearingDate() != null) {
            jsonObject.addProperty("nextDate", DateUtils.getDefaultFormattedDate((Date)dueReportResult.getHearingDate()));
        } else if (dueReportResult.getJudgementImplDate() != null) {
            jsonObject.addProperty("nextDate", DateUtils.getDefaultFormattedDate((Date)dueReportResult.getJudgementImplDate()));
        } else {
            jsonObject.addProperty("nextDate", dueReportResult.getLegalCase().getCaseDate() == null ? "" : DateUtils.getDefaultFormattedDate((Date)dueReportResult.getLegalCase().getCaseDate()));
        }
        return jsonObject;
    }
}

