/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.masters.service.InterimOrderService;
import org.egov.lcms.transactions.entity.LcInterimOrderDocuments;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.egov.lcms.transactions.service.LegalCaseInterimOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/lcinterimorder"})
public class ViewAndEditLegalCaseInterimOrderController {
    @Autowired
    private LegalCaseInterimOrderService legalCaseInterimOrderService;
    @Autowired
    private InterimOrderService interimOrderService;

    @ModelAttribute
    public LegalCaseInterimOrder getLcInterimOrder(@PathVariable String lcInterimOrderId) {
        LegalCaseInterimOrder legalCaseInterimOrder = this.legalCaseInterimOrderService.findById(Long.valueOf(Long.parseLong(lcInterimOrderId)));
        return legalCaseInterimOrder;
    }

    @RequestMapping(value={"/edit/{lcInterimOrderId}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="lcInterimOrderId") String lcInterimOrderId, Model model, HttpServletRequest request) {
        LegalCaseInterimOrder legalCaseInterimOrder = this.getLcInterimOrder(lcInterimOrderId);
        model.addAttribute("interimOrders", (Object)this.interimOrderService.findAll());
        model.addAttribute("legalCaseInterimOrder", (Object)legalCaseInterimOrder);
        model.addAttribute("legalCase", (Object)legalCaseInterimOrder.getLegalCase());
        model.addAttribute("lcNumber", (Object)legalCaseInterimOrder.getLegalCase().getLcNumber());
        model.addAttribute("supportDocs", !legalCaseInterimOrder.getLcInterimOrderDocuments().isEmpty() && legalCaseInterimOrder.getLcInterimOrderDocuments().get(0) != null ? ((LcInterimOrderDocuments)legalCaseInterimOrder.getLcInterimOrderDocuments().get(0)).getSupportDocs() : null);
        model.addAttribute("mode", (Object)"edit");
        return "lcinterimorder-edit";
    }

    @RequestMapping(value={"/edit/{lcInterimOrderId}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute(value="legalCaseInterimOrder") LegalCaseInterimOrder legalCaseInterimOrder, BindingResult errors, RedirectAttributes redirectAttrs, @PathVariable(value="lcInterimOrderId") String lcInterimOrderId, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("interimOrders", (Object)this.interimOrderService.findAll());
            return "lcinterimorder-edit";
        }
        this.legalCaseInterimOrderService.persist(legalCaseInterimOrder);
        redirectAttrs.addFlashAttribute("legalCaseInterimOrder", (Object)legalCaseInterimOrder);
        model.addAttribute("supportDocs", !legalCaseInterimOrder.getLcInterimOrderDocuments().isEmpty() && legalCaseInterimOrder.getLcInterimOrderDocuments().get(0) != null ? ((LcInterimOrderDocuments)legalCaseInterimOrder.getLcInterimOrderDocuments().get(0)).getSupportDocs() : null);
        model.addAttribute("message", (Object)"InterimOrder updated successfully.");
        model.addAttribute("mode", (Object)"edit");
        return "lcinterimorder-success";
    }

    @RequestMapping(value={"/view/{lcInterimOrderId}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="lcInterimOrderId") String lcInterimOrderId, Model model) {
        LegalCaseInterimOrder legalCaseInterimOrder = this.getLcInterimOrder(lcInterimOrderId);
        model.addAttribute("legalCaseInterimOrder", (Object)legalCaseInterimOrder);
        model.addAttribute("lcNumber", (Object)legalCaseInterimOrder.getLegalCase().getLcNumber());
        model.addAttribute("supportDocs", !legalCaseInterimOrder.getLcInterimOrderDocuments().isEmpty() && legalCaseInterimOrder.getLcInterimOrderDocuments().get(0) != null ? ((LcInterimOrderDocuments)legalCaseInterimOrder.getLcInterimOrderDocuments().get(0)).getSupportDocs() : null);
        model.addAttribute("mode", (Object)"view");
        return "lcinterimorder-success";
    }
}

