/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import org.egov.lcms.masters.service.CourtMasterService;
import org.egov.lcms.masters.service.PetitionTypeMasterService;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseDocuments;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.egov.lcms.web.controller.transactions.GenericLegalCaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application/"})
public class ViewAndEditLegalCaseController
extends GenericLegalCaseController {
    @Autowired
    private LegalCaseService legalCaseService;
    @Autowired
    private PetitionTypeMasterService petitiontypeMasterService;
    @Autowired
    private CourtMasterService courtMasterService;

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        return legalCase;
    }

    @RequestMapping(value={"/view/"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="lcNumber") String lcNumber, Model model) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        model.addAttribute("legalCase", (Object)legalCase);
        model.addAttribute("mode", (Object)"view");
        model.addAttribute("supportDocs", !legalCase.getLegalCaseDocuments().isEmpty() && legalCase.getLegalCaseDocuments().get(0) != null ? ((LegalCaseDocuments)legalCase.getLegalCaseDocuments().get(0)).getSupportDocs() : null);
        model.addAttribute("pwrDocList", (Object)this.legalCaseService.getPwrDocList(legalCase));
        return "legalcasedetails-view";
    }

    @RequestMapping(value={"/edit/"}, method={RequestMethod.GET})
    public String edit(@RequestParam(value="lcNumber") String lcNumber, Model model) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        model.addAttribute("legalCase", (Object)legalCase);
        this.setDropDownValues(model);
        String[] casenumberyear = legalCase.getCaseNumber().split("/");
        legalCase.setCaseNumber(casenumberyear[0]);
        if (casenumberyear.length > 1) {
            legalCase.setWpYear(casenumberyear[1]);
        }
        legalCase.getBipartisanPetitionerDetailsList().addAll(legalCase.getPetitioners());
        legalCase.getBipartisanRespondentDetailsList().addAll(legalCase.getRespondents());
        model.addAttribute("supportDocs", !legalCase.getLegalCaseDocuments().isEmpty() && legalCase.getLegalCaseDocuments().get(0) != null ? ((LegalCaseDocuments)legalCase.getLegalCaseDocuments().get(0)).getSupportDocs() : null);
        model.addAttribute("mode", (Object)"edit");
        return "legalcase-edit";
    }

    @RequestMapping(value={"/edit/"}, method={RequestMethod.POST})
    public String update(@ModelAttribute LegalCase legalCase, @RequestParam(value="lcNumber") String lcNumber, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "legalcase-edit";
        }
        this.legalCaseService.persist(legalCase);
        this.setDropDownValues(model);
        redirectAttrs.addFlashAttribute("legalCase", (Object)legalCase);
        model.addAttribute("mode", (Object)"edit");
        model.addAttribute("message", (Object)"LegalCase updated successfully.");
        model.addAttribute("supportDocs", !legalCase.getLegalCaseDocuments().isEmpty() && legalCase.getLegalCaseDocuments().get(0) != null ? ((LegalCaseDocuments)legalCase.getLegalCaseDocuments().get(0)).getSupportDocs() : null);
        return "legalcase-success";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("courtsList", (Object)this.courtMasterService.findAll());
        model.addAttribute("petitiontypeList", (Object)this.petitiontypeMasterService.getPetitiontypeList());
    }
}

