/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.masters.service.InterimOrderService;
import org.egov.lcms.transactions.entity.LcInterimOrderDocuments;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.egov.lcms.transactions.service.LegalCaseInterimOrderService;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/lcinterimorder"})
public class LegalCaseInterimOrderController {
    @Autowired
    private LegalCaseInterimOrderService legalCaseInterimOrderService;
    @Autowired
    private LegalCaseService legalcaseService;
    @Autowired
    private InterimOrderService interimOrderService;

    @RequestMapping(value={"/new/"}, method={RequestMethod.GET})
    public String viewForm(@ModelAttribute(value="legalCaseInterimOrder") LegalCaseInterimOrder legalCaseInterimOrder, @RequestParam(value="lcNumber") String lcNumber, Model model, HttpServletRequest request) {
        LegalCase legalCase = this.getLegalCase(lcNumber, request);
        model.addAttribute("legalCase", (Object)legalCase);
        model.addAttribute("interimOrders", (Object)this.interimOrderService.getActiveInterimOrder());
        model.addAttribute("legalCaseInterimOrder", (Object)legalCaseInterimOrder);
        model.addAttribute("lcNumber", (Object)legalCase.getLcNumber());
        model.addAttribute("mode", (Object)"create");
        return "lcinterimorder-new";
    }

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request) {
        LegalCase legalCase = this.legalcaseService.findByLcNumber(lcNumber);
        return legalCase;
    }

    @RequestMapping(value={"/new/"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute(value="legalCaseInterimOrder") LegalCaseInterimOrder legalCaseInterimOrder, BindingResult errors, RedirectAttributes redirectAttrs, @RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request, Model model) {
        LegalCase legalCase = this.getLegalCase(lcNumber, request);
        if (errors.hasErrors()) {
            model.addAttribute("interimOrders", (Object)this.interimOrderService.getActiveInterimOrder());
            model.addAttribute("legalCase", (Object)legalCase);
            return "lcinterimorder-new";
        }
        legalCaseInterimOrder.setLegalCase(legalCase);
        this.legalCaseInterimOrderService.persist(legalCaseInterimOrder);
        model.addAttribute("mode", (Object)"create");
        model.addAttribute("supportDocs", !legalCaseInterimOrder.getLcInterimOrderDocuments().isEmpty() && legalCaseInterimOrder.getLcInterimOrderDocuments().get(0) != null ? ((LcInterimOrderDocuments)legalCaseInterimOrder.getLcInterimOrderDocuments().get(0)).getSupportDocs() : null);
        model.addAttribute("lcNumber", (Object)legalCase.getLcNumber());
        redirectAttrs.addFlashAttribute("legalCaseInterimOrder", (Object)legalCaseInterimOrder);
        model.addAttribute("message", (Object)"Interim Order Created successfully.");
        return "lcinterimorder-success";
    }

    @RequestMapping(value={"/list/"}, method={RequestMethod.GET})
    public String getInterimOrderList(Model model, @RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request) {
        LegalCase legalCase = this.getLegalCase(lcNumber, request);
        List lcInterimOrderList = this.legalCaseInterimOrderService.findByLCNumber(lcNumber);
        model.addAttribute("legalCase", (Object)legalCase);
        model.addAttribute("lcNumber", (Object)legalCase.getLcNumber());
        model.addAttribute("lcInterimOrderId", (Object)legalCase.getLegalCaseInterimOrder());
        model.addAttribute("lcInterimOrderList", (Object)lcInterimOrderList);
        return "lcinterimorder-list";
    }
}

