/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.transactions.entity.Hearings;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.service.HearingsService;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hearing"})
public class HearingsController {
    @Autowired
    private HearingsService hearingsService;
    @Autowired
    private LegalCaseService legalCaseService;

    @RequestMapping(value={"/new/"}, method={RequestMethod.GET})
    public String newForm(@ModelAttribute(value="hearings") Hearings hearings, Model model, @RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request) {
        LegalCase legalCase = this.getLegalCase(lcNumber, request);
        model.addAttribute("legalCase", (Object)legalCase);
        model.addAttribute("positionTemplList", (Object)hearings.getPositionTemplList());
        model.addAttribute("hearings", (Object)hearings);
        model.addAttribute("mode", (Object)"create");
        return "hearings-new";
    }

    @ModelAttribute
    private LegalCase getLegalCase(@RequestParam(value="lcNumber") String lcNumber, HttpServletRequest request) {
        LegalCase legalCase = this.legalCaseService.findByLcNumber(lcNumber);
        return legalCase;
    }

    @RequestMapping(value={"/new/"}, method={RequestMethod.POST})
    public String create(@ModelAttribute Hearings hearings, BindingResult errors, @RequestParam(value="lcNumber") String lcNumber, RedirectAttributes redirectAttrs, Model model, HttpServletRequest request) {
        LegalCase legalCase = this.getLegalCase(lcNumber, request);
        this.hearingsService.validateDate(hearings, legalCase, errors);
        if (errors.hasErrors()) {
            model.addAttribute("legalCase", (Object)legalCase);
            return "hearings-new";
        }
        hearings.setLegalCase(legalCase);
        this.hearingsService.persist(hearings);
        redirectAttrs.addFlashAttribute("hearings", (Object)hearings);
        model.addAttribute("message", (Object)"Hearing created successfully.");
        model.addAttribute("mode", (Object)"create");
        return "hearings-success";
    }

    @RequestMapping(value={"/list/"}, method={RequestMethod.GET})
    public String getHearingsList(Model model, @RequestParam(value="lcNumber") String lcNumber, @Valid @ModelAttribute Hearings hearings, HttpServletRequest request) {
        LegalCase legalCase = this.getLegalCase(lcNumber, request);
        List hearingsList = this.hearingsService.findByLCNumber(lcNumber);
        model.addAttribute("legalCase", (Object)legalCase);
        model.addAttribute("lcNumber", (Object)legalCase.getLcNumber());
        model.addAttribute("hearingsId", (Object)legalCase.getHearings());
        model.addAttribute("positionTemplList", (Object)hearings.getPositionTemplList());
        model.addAttribute("hearings", (Object)hearings);
        model.addAttribute("hearingsList", (Object)hearingsList);
        return "hearings-list";
    }
}

