/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.masters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.lcms.masters.entity.InterimOrder;
import org.egov.lcms.masters.service.InterimOrderService;
import org.egov.lcms.web.adaptor.InterimOrderJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/interimorder"})
public class InterimOrderController {
    private static final String INTERIMORDER_NEW = "interimorder-new";
    private static final String INTERIMORDER_RESULT = "interimorder-result";
    private static final String INTERIMORDER_EDIT = "interimorder-edit";
    private static final String INTERIMORDER_VIEW = "interimorder-view";
    private static final String INTERIMORDER_SEARCH = "interimorder-search";
    @Autowired
    private InterimOrderService interimOrderService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("interimOrder", (Object)new InterimOrder());
        return INTERIMORDER_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute InterimOrder interimOrder, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return INTERIMORDER_NEW;
        }
        this.interimOrderService.create(interimOrder);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.interimOrder.success", null, null));
        return "redirect:/interimorder/result/" + interimOrder.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        InterimOrder interimOrder = this.interimOrderService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("interimOrder", (Object)interimOrder);
        return INTERIMORDER_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute InterimOrder interimOrder, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return INTERIMORDER_EDIT;
        }
        this.interimOrderService.update(interimOrder);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.interimOrder.update", null, null));
        return "redirect:/interimorder/result/" + interimOrder.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        InterimOrder interimOrder = this.interimOrderService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("interimOrder", (Object)interimOrder);
        return INTERIMORDER_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        InterimOrder interimOrder = this.interimOrderService.findOne(id);
        model.addAttribute("interimOrder", (Object)interimOrder);
        return INTERIMORDER_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        InterimOrder interimOrder = new InterimOrder();
        this.prepareNewForm(model);
        model.addAttribute("interimOrder", (Object)interimOrder);
        return INTERIMORDER_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute InterimOrder interimOrder) {
        List searchResultList = this.interimOrderService.search(interimOrder);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(InterimOrder.class, (Object)new InterimOrderJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

