/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.reports;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.commons.EgwStatus;
import org.egov.infra.web.utils.WebUtils;
import org.egov.lcms.masters.entity.JudgmentType;
import org.egov.lcms.masters.service.JudgmentTypeService;
import org.egov.lcms.reports.entity.GenericSubReportResult;
import org.egov.lcms.transactions.service.GenericSubReportService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.egov.lcms.web.adaptor.GenericSubReportAdaptor;
import org.egov.lcms.web.controller.transactions.GenericLegalCaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class GenericSubReportController
extends GenericLegalCaseController {
    @Autowired
    private GenericSubReportService genericSubReportService;
    @Autowired
    private JudgmentTypeService judgmentTypeService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @ModelAttribute
    public void getGenericSubReport(Model model) {
        GenericSubReportResult genericSubReportResult = new GenericSubReportResult();
        model.addAttribute("genericSubReportResult", (Object)genericSubReportResult);
    }

    @ModelAttribute(value="judgmentTypeList")
    public List<JudgmentType> judgmentTypeList() {
        return this.judgmentTypeService.getActiveJudgementTypes();
    }

    @ModelAttribute(value="statusList")
    public List<EgwStatus> statusList() {
        return this.legalCaseUtil.getStatusForModule();
    }

    @ModelAttribute(value="aggregatedByList")
    public List<String> defaultersList() {
        ArrayList<String> aggregatedByList = new ArrayList<String>();
        aggregatedByList.add("Court Name");
        aggregatedByList.add("Court Type");
        aggregatedByList.add("Petition Type");
        aggregatedByList.add("Case Status");
        aggregatedByList.add("In charge officer");
        aggregatedByList.add("Judgement outcome");
        return aggregatedByList;
    }

    @RequestMapping(value={"/genericSubReport"}, method={RequestMethod.GET})
    public String searchForm(Model model, @ModelAttribute(value="genericSubReportResult") GenericSubReportResult genericSubReportResult) {
        model.addAttribute("currDate", (Object)new Date());
        model.addAttribute("genericSubReportResult", (Object)genericSubReportResult);
        return "genericsub-form";
    }

    @RequestMapping(value={"/genericSubResult"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getGenerivSubReportResult(HttpServletRequest request, HttpServletResponse response, @ModelAttribute(value="genericSubReportResult") GenericSubReportResult genericSubReportResult) throws IOException, ParseException {
        List genericSubResultList = new ArrayList();
        genericSubResultList = this.genericSubReportService.getGenericSubReport(genericSubReportResult);
        String result = "{ \"data\":" + WebUtils.toJSON(genericSubResultList, GenericSubReportResult.class, GenericSubReportAdaptor.class) + "}";
        return result;
    }
}

