/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.masters;

import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.web.utils.WebUtils;
import org.egov.lcms.masters.entity.CaseTypeMaster;
import org.egov.lcms.masters.service.CaseTypeMasterService;
import org.egov.lcms.web.adaptor.CaseTypeMasterJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/casetypemaster"})
public class CaseTypeMasterController {
    private static final String CASETYPEMASTER_NEW = "casetypemaster-new";
    private static final String CASETYPEMASTER_RESULT = "casetypemaster-result";
    private static final String CASETYPEMASTER_EDIT = "casetypemaster-edit";
    private static final String CASETYPEMASTER_VIEW = "casetypemaster-view";
    private static final String CASETYPEMASTER_SEARCH = "casetypemaster-search";
    @Autowired
    private CaseTypeMasterService casetypeMasterService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("caseTypeMaster", (Object)new CaseTypeMaster());
        return CASETYPEMASTER_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CaseTypeMaster casetypeMaster, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return CASETYPEMASTER_NEW;
        }
        this.casetypeMasterService.create(casetypeMaster);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.casetypeMaster.success", null, null));
        return "redirect:/casetypemaster/result/" + casetypeMaster.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        CaseTypeMaster casetypeMaster = this.casetypeMasterService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("caseTypeMaster", (Object)casetypeMaster);
        return CASETYPEMASTER_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CaseTypeMaster casetypeMaster, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return CASETYPEMASTER_EDIT;
        }
        this.casetypeMasterService.update(casetypeMaster);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.casetypeMaster.update", null, null));
        return "redirect:/casetypemaster/result/" + casetypeMaster.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CaseTypeMaster casetypeMaster = this.casetypeMasterService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("casetypeMaster", (Object)casetypeMaster);
        return CASETYPEMASTER_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CaseTypeMaster casetypeMaster = this.casetypeMasterService.findOne(id);
        model.addAttribute("casetypeMaster", (Object)casetypeMaster);
        return CASETYPEMASTER_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CaseTypeMaster casetypeMaster = new CaseTypeMaster();
        this.prepareNewForm(model);
        model.addAttribute("casetypeMaster", (Object)casetypeMaster);
        return CASETYPEMASTER_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CaseTypeMaster casetypeMaster) {
        List searchResultList = this.casetypeMasterService.search(casetypeMaster);
        String result = "{ \"data\":" + WebUtils.toJSON((Collection)searchResultList, CaseTypeMaster.class, CaseTypeMasterJsonAdaptor.class) + "}";
        return result;
    }
}

