/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EmployeeService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.lcms.transactions.entity.AppealDocuments;
import org.egov.lcms.transactions.entity.BipartisanDetails;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.JudgmentDocuments;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.egov.lcms.transactions.entity.LcInterimOrderDocuments;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.egov.lcms.transactions.entity.LegalCaseUploadDocuments;
import org.egov.lcms.transactions.entity.PwrDocuments;
import org.egov.lcms.transactions.repository.JudgmentImplRepository;
import org.egov.lcms.transactions.repository.JudgmentRepository;
import org.egov.lcms.transactions.repository.LegalCaseInterimOrderRepository;
import org.egov.lcms.transactions.repository.LegalCaseRepository;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LegalCaseUtil {
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    private LegalCaseRepository legalCaseRepository;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private FileStoreUtils fileStoreUtils;
    @Autowired
    private JudgmentRepository judgmentRepository;
    @Autowired
    private JudgmentImplRepository judgmentImplRepository;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private LegalCaseInterimOrderRepository legalCaseInterimOrderRepository;

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusForModuleAndCode(String moduleName, String statusCode) {
        EgwStatus status = this.egwStatusDAO.getStatusByModuleAndCode(moduleName, statusCode);
        return status;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<EgwStatus> getStatusForModule() {
        List statusList = this.egwStatusDAO.getStatusByModule("Legal Case");
        return statusList;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Position getPositionByName(String name) {
        return this.positionMasterService.getPositionByName(name);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Department getDepartmentByName(String name) {
        return this.departmentService.getDepartmentByName(name);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<BipartisanDetails> getBipartitionList(LegalCase legalcase) {
        return this.legalCaseRepository.getBipartitionDetList(legalcase.getId());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<LegalCaseUploadDocuments> getLegalCaseDocumentList(LegalCase legalcase) {
        List<LegalCaseUploadDocuments> legalDoc = this.legalCaseRepository.getLegalCaseUploadDocumentList(legalcase.getId());
        return legalDoc;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<JudgmentDocuments> getJudgmentDocumentList(Judgment judgment) {
        List<JudgmentDocuments> judgmentDoc = this.judgmentRepository.getJudgmentDocumentList(judgment.getId());
        return judgmentDoc;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<LcInterimOrderDocuments> getLcInterimOrderDocumentList(LegalCaseInterimOrder legalCaseInterimOrder) {
        List<LcInterimOrderDocuments> interimOrderDoc = this.legalCaseInterimOrderRepository.getLcInterimOrderDocumentList(legalCaseInterimOrder.getId());
        return interimOrderDoc;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Employee getEmployeeByUserName(String userName) {
        Employee employee = this.employeeService.getEmployeeByUserName(userName);
        return employee;
    }

    @Transactional
    public Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        return this.fileStoreUtils.addToFileStore(files, "LCMS");
    }

    public List<PwrDocuments> getPwrDocumentList(LegalCase legalcase) {
        List<PwrDocuments> pwrDoc = this.legalCaseRepository.getPwrDocumentList(legalcase.getPwrList().get(0).getId());
        return pwrDoc;
    }

    public List<AppealDocuments> getAppealDocumentList(JudgmentImpl judgmentImpl) {
        List<AppealDocuments> appealDoc = this.judgmentImplRepository.getAppealDocumentList(judgmentImpl.getAppeal().get(0).getId());
        return appealDoc;
    }

    public String getOfficerInchargeMobileNumber(LegalCase legalcase) {
        Assignment assignment = null;
        if (legalcase != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(legalcase.getOfficerIncharge().getId(), new Date());
        }
        return assignment != null ? assignment.getEmployee().getMobileNumber() : "";
    }

    public void sendSMSOnLegalCase(String mobileNumber, String smsBody) {
        this.messagingService.sendSMS(mobileNumber, smsBody);
    }

    public String getOfficerInchargeName(LegalCase legalcase) {
        Assignment assignment = null;
        if (legalcase != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(legalcase.getOfficerIncharge().getId(), new Date());
        }
        return assignment != null ? assignment.getEmployee().getName() : "";
    }

    public static Map<String, Integer> getAllMonthsInNumber() {
        HashMap<String, Integer> monthMap = new HashMap<String, Integer>();
        monthMap.put("Jan", 1);
        monthMap.put("Feb", 2);
        monthMap.put("Mar", 3);
        monthMap.put("Apr", 4);
        monthMap.put("May", 5);
        monthMap.put("Jun", 6);
        monthMap.put("July", 7);
        monthMap.put("Aug", 8);
        monthMap.put("Sep", 9);
        monthMap.put("Oct", 10);
        monthMap.put("Nov", 11);
        monthMap.put("Dec", 12);
        return monthMap;
    }
}

