/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.DateUtils;
import org.egov.lcms.reports.entity.TimeSeriesReportResult;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.stereotype.Service;

@Service
public class TimeSeriesReportService {
    private static final String AGGREGATION_BY_FIELD = "aggregationField";
    private static final String COURTNAME = "courtName";
    private static final String PETITIONTYPE = "petitionType";
    private static final String CASETYPE = "caseType";
    private static final String COURTTYPE = "courtType";
    private static final String CASESTATUS = "status";
    private static final String OFFICERINCHRGE = "officerIncharge";
    private static final String STANDINGCOUNSEL = "advocateName";
    public static final String MONTH = "month";
    public static final String YEAR = "year";
    public static final String MONTHLY = "monthly";
    public static final String YEARLY = "yearly";
    private static final String CASE_DATE = "caseDate";
    private static final String TOTAL_COUNT = "total_count";
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public List<TimeSeriesReportResult> getTimeSeriesReportsResults(TimeSeriesReportResult timeSeriesReportResult) throws ParseException {
        String aggregationField = this.getAggregationFiledByType(timeSeriesReportResult);
        Map monthValuesMap = DateUtils.getAllMonths();
        SearchResponse timeSeriesReport = this.findAllLegalcaseDocumentByFilter(timeSeriesReportResult, this.getFilterQuery(timeSeriesReportResult), aggregationField);
        String aggregationName = "";
        if (StringUtils.isNotBlank((CharSequence)timeSeriesReportResult.getPeriod())) {
            if (MONTH.equalsIgnoreCase(timeSeriesReportResult.getPeriod())) {
                aggregationName = MONTHLY;
            } else if (YEAR.equalsIgnoreCase(timeSeriesReportResult.getPeriod())) {
                aggregationName = YEARLY;
            }
        }
        ArrayList<TimeSeriesReportResult> responseDetailsList = new ArrayList<TimeSeriesReportResult>();
        Terms terms = (Terms)timeSeriesReport.getAggregations().get(AGGREGATION_BY_FIELD);
        for (Terms.Bucket bucket : terms.getBuckets()) {
            Histogram agg = (Histogram)bucket.getAggregations().get(aggregationName);
            for (Histogram.Bucket entry : agg.getBuckets()) {
                String[] dateArr = entry.getKeyAsString().split("T");
                ValueCount valueCount = (ValueCount)entry.getAggregations().get(TOTAL_COUNT);
                if (valueCount.getValue() <= 0L) continue;
                TimeSeriesReportResult responseDetail = new TimeSeriesReportResult();
                responseDetail.setAggregatedBy(bucket.getKeyAsString());
                responseDetail.setYear(dateArr[0].split("-", 3)[0]);
                Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                String monthName = (String)monthValuesMap.get(month);
                responseDetail.setMonth(monthName);
                responseDetail.setCount(valueCount.getValue());
                responseDetailsList.add(responseDetail);
            }
        }
        return responseDetailsList;
    }

    public SearchResponse findAllLegalcaseDocumentByFilter(TimeSeriesReportResult timeSeriesReportResult, BoolQueryBuilder query, String aggregationField) {
        DateHistogramInterval interval = null;
        String aggregationName = "";
        if (StringUtils.isNotBlank((CharSequence)timeSeriesReportResult.getPeriod())) {
            if (MONTH.equalsIgnoreCase(timeSeriesReportResult.getPeriod())) {
                interval = DateHistogramInterval.MONTH;
                aggregationName = MONTHLY;
            } else if (YEAR.equalsIgnoreCase(timeSeriesReportResult.getPeriod())) {
                interval = DateHistogramInterval.YEAR;
                aggregationName = YEARLY;
            }
        }
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"legalcasedocument"}).setQuery((QueryBuilder)query).addAggregation((AbstractAggregationBuilder)TimeSeriesReportService.getCountWithGrouping(AGGREGATION_BY_FIELD, aggregationField).subAggregation((AbstractAggregationBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)aggregationName).field(CASE_DATE)).interval(interval).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)TOTAL_COUNT).field("lcNumber")))).execute().actionGet();
    }

    private String getAggregationFiledByType(TimeSeriesReportResult timeSeriesReportResult) {
        String aggregationField = "";
        if (StringUtils.isNotBlank((CharSequence)timeSeriesReportResult.getAggregatedBy())) {
            if (timeSeriesReportResult.getAggregatedBy().equals("Court Name")) {
                aggregationField = COURTNAME;
            } else if (timeSeriesReportResult.getAggregatedBy().equals("Petition Type")) {
                aggregationField = PETITIONTYPE;
            } else if (timeSeriesReportResult.getAggregatedBy().equals("Case Category")) {
                aggregationField = CASETYPE;
            } else if (timeSeriesReportResult.getAggregatedBy().equals("Case Status")) {
                aggregationField = CASESTATUS;
            } else if (timeSeriesReportResult.getAggregatedBy().equals("Court Type")) {
                aggregationField = COURTTYPE;
            } else if (timeSeriesReportResult.getAggregatedBy().equals("In charge officer")) {
                aggregationField = OFFICERINCHRGE;
            } else if (timeSeriesReportResult.getAggregatedBy().equals("Standing Counsel")) {
                aggregationField = STANDINGCOUNSEL;
            }
        }
        return aggregationField;
    }

    private BoolQueryBuilder getFilterQuery(TimeSeriesReportResult searchRequest) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat newFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"cityName", (String)ApplicationThreadLocals.getCityName()));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseFromDate())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)CASE_DATE).gte(newFormat.format(formatter.parse(searchRequest.getCaseFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getCaseToDate())))));
        }
        return boolQuery;
    }

    public static AggregationBuilder getCountWithGrouping(String aggregationName, String fieldName) {
        return AggregationBuilders.terms((String)aggregationName).field(fieldName);
    }
}

