/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.lcms.entity.es.HearingsDocument;
import org.egov.lcms.entity.es.LegalCaseDocument;
import org.egov.lcms.reports.entity.LegalCommonReportResult;
import org.egov.lcms.repository.es.HearingsDocumentRepository;
import org.egov.lcms.repository.es.LegalCaseDocumentRepository;
import org.egov.lcms.utils.LegalCaseUtil;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class LegalCommonReportService {
    private static final String COURTNAME = "courtName";
    private static final String PETITIONTYPE = "petitionType";
    private static final String CASETYPE = "caseType";
    private static final String COURTTYPE = "courtType";
    private static final String CASESTATUS = "status";
    private static final String OFFICERINCHRGE = "officerIncharge";
    private static final String STANDINGCOUNSEL = "advocateName";
    public static final String MONTH = "month";
    public static final String YEAR = "year";
    public static final String MONTHLY = "monthly";
    public static final String YEARLY = "yearly";
    private static final String CASE_DATE = "caseDate";
    private static final String JUDGEMENTOUTCOME = "judgmentOutcome";
    @Autowired
    private LegalCaseDocumentRepository legalCaseDocumentRepository;
    @Autowired
    private HearingsDocumentRepository hearingsDocumentRepository;

    public List<LegalCommonReportResult> getLegalCommonReportsResults(LegalCommonReportResult legalCommonReport, String reportType) throws ParseException {
        List<LegalCaseDocument> legalcaseDocumentList = this.findAllLegalcaseDocumentIndexByFilter(legalCommonReport, reportType);
        return this.prepareLegalCaseDocumentList(legalcaseDocumentList);
    }

    public List<LegalCommonReportResult> prepareLegalCaseDocumentList(List<LegalCaseDocument> legalcaseDocumentList) throws ParseException {
        ArrayList<LegalCommonReportResult> documentList = new ArrayList<LegalCommonReportResult>(0);
        for (LegalCaseDocument legalcaseDocument : legalcaseDocumentList) {
            documentList.addAll(this.buildLegalReport(legalcaseDocument));
        }
        return documentList;
    }

    public List<LegalCaseDocument> findAllLegalcaseDocumentIndexByFilter(LegalCommonReportResult legalCommonReportResult, String reportType) throws ParseException {
        Iterable<LegalCaseDocument> legalcaseDocumentSearchList = this.getLegalcaseIndex(legalCommonReportResult, reportType);
        ArrayList<LegalCaseDocument> legalcaseDocumentList = new ArrayList<LegalCaseDocument>();
        for (LegalCaseDocument documentObj : legalcaseDocumentSearchList) {
            legalcaseDocumentList.add(documentObj);
        }
        return legalcaseDocumentList;
    }

    private Iterable<LegalCaseDocument> getLegalcaseIndex(LegalCommonReportResult legalCommonReportResult, String reportType) throws ParseException {
        BoolQueryBuilder query = this.getFilterQuery(legalCommonReportResult, reportType);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"legalcasedocument"}).withQuery((QueryBuilder)query).withPageable((Pageable)new PageRequest(0, 250)).build();
        Page legalcaseDocumentSearchList = this.legalCaseDocumentRepository.search((SearchQuery)searchQuery);
        return legalcaseDocumentSearchList;
    }

    public List<LegalCommonReportResult> buildLegalReport(LegalCaseDocument legalcaseDocument) throws ParseException {
        ArrayList<LegalCommonReportResult> finalResult = new ArrayList<LegalCommonReportResult>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
        SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
        LegalCommonReportResult legalCommonResultObj = new LegalCommonReportResult();
        legalCommonResultObj.setCaseNumber(legalcaseDocument.getCaseNumber() != null ? legalcaseDocument.getCaseNumber() : "");
        legalCommonResultObj.setLcNumber(legalcaseDocument.getLcNumber() != null ? legalcaseDocument.getLcNumber() : "");
        legalCommonResultObj.setCaseTitle(legalcaseDocument.getCaseTitle() != null ? legalcaseDocument.getCaseTitle() : "");
        legalCommonResultObj.setCourtName(legalcaseDocument.getCourtName() != null ? legalcaseDocument.getCourtName() : "");
        legalCommonResultObj.setPetitionerName(legalcaseDocument.getPetitionerNames() != null ? legalcaseDocument.getPetitionerNames() : "");
        legalCommonResultObj.setRespondantName(legalcaseDocument.getRespondantNames() != null ? legalcaseDocument.getRespondantNames() : "");
        legalCommonResultObj.setStandingCounsel(legalcaseDocument.getAdvocateName() != null ? legalcaseDocument.getAdvocateName() : "");
        legalCommonResultObj.setOfficerIncharge(legalcaseDocument.getOfficerIncharge() != null ? legalcaseDocument.getOfficerIncharge() : "");
        legalCommonResultObj.setCaseStatus(legalcaseDocument.getStatus() != null ? legalcaseDocument.getStatus() : "");
        legalCommonResultObj.setReportStatus(legalcaseDocument.getSubStatus() != null ? legalcaseDocument.getSubStatus() : "");
        legalCommonResultObj.setPetitionType(legalcaseDocument.getPetitionType() != null ? legalcaseDocument.getPetitionType() : "");
        legalCommonResultObj.setNextDate(legalcaseDocument.getNextDate() != null ? myFormat.format(dateFormat.parse(legalcaseDocument.getNextDate().toString())) : "");
        finalResult.add(legalCommonResultObj);
        return finalResult;
    }

    private BoolQueryBuilder getFilterQuery(LegalCommonReportResult searchRequest, String reportType) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat newFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Map<String, Integer> monthValuesMapnumber = LegalCaseUtil.getAllMonthsInNumber();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"cityName", (String)ApplicationThreadLocals.getCityName()));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getAggregatedByValue())) {
            if (searchRequest.getAggregatedBy().equals("Court Name")) {
                boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)COURTNAME, (Object)searchRequest.getAggregatedByValue()));
            }
            if (searchRequest.getAggregatedBy().equals("Petition Type")) {
                boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)PETITIONTYPE, (Object)searchRequest.getAggregatedByValue()));
            } else if (searchRequest.getAggregatedBy().equals("Case Category")) {
                boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CASETYPE, (Object)searchRequest.getAggregatedByValue()));
            } else if (searchRequest.getAggregatedBy().equals("Case Status")) {
                boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CASESTATUS, (Object)searchRequest.getAggregatedByValue()));
            } else if (searchRequest.getAggregatedBy().equals("Court Type")) {
                boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)COURTTYPE, (Object)searchRequest.getAggregatedByValue()));
            } else if (searchRequest.getAggregatedBy().equals("In charge officer")) {
                boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)OFFICERINCHRGE, (Object)searchRequest.getAggregatedByValue().split("@")[0]));
            } else if (searchRequest.getAggregatedBy().equals("Standing Counsel")) {
                boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)STANDINGCOUNSEL, (Object)searchRequest.getAggregatedByValue()));
            } else if (searchRequest.getAggregatedBy().equals("Judgment outcome")) {
                boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)JUDGEMENTOUTCOME, (Object)searchRequest.getAggregatedByValue()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getMonth()) && StringUtils.isNotBlank((CharSequence)searchRequest.getYear())) {
            String endDate;
            String startDate;
            Integer monthName = monthValuesMapnumber.get(searchRequest.getMonth());
            String monthYearStartDateStr = searchRequest.getYear().concat("-").concat(monthName.toString()).concat("-").concat("01");
            LocalDate monthYearStDate = new LocalDate((Object)monthYearStartDateStr);
            if (MONTH.equalsIgnoreCase(searchRequest.getPeriod())) {
                LocalDate weekStart = monthYearStDate.dayOfWeek().withMinimumValue();
                LocalDate endOfMonth = monthYearStDate.dayOfMonth().withMaximumValue();
                startDate = weekStart.toString("dd/MM/yyyy");
                endDate = endOfMonth.toString("dd/MM/yyyy");
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)CASE_DATE).gte(newFormat.format(formatter.parse(startDate))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(endDate)))));
            }
            if (YEAR.equalsIgnoreCase(searchRequest.getPeriod())) {
                LocalDate monthStart = monthYearStDate.dayOfMonth().withMinimumValue();
                LocalDate endOfYear = monthYearStDate.dayOfYear().withMaximumValue();
                startDate = monthStart.toString("dd/MM/yyyy");
                endDate = endOfYear.toString("dd/MM/yyyy");
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)CASE_DATE).gte(newFormat.format(formatter.parse(startDate))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(endDate)))));
            }
        }
        if (reportType != null) {
            if (reportType.equals("PWR due date")) {
                boolQuery.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"pwrDueDate"));
            } else if (reportType.equals("CA Due date")) {
                boolQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)"caDueDate"));
            } else if (reportType.equals("Judgement Implementation")) {
                boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)CASESTATUS, (Object)"Closed"));
            }
            if (reportType.equals("Judgement Implementation") && StringUtils.isNotBlank((CharSequence)searchRequest.getCaseFromDate())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"judgmentImplDate").gte(newFormat.format(formatter.parse(searchRequest.getCaseFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getCaseToDate())))));
            }
            if (reportType.equals("Employee Hearings")) {
                ArrayList<String> statusCodeList = new ArrayList<String>();
                statusCodeList.add("Hearing In Progress");
                statusCodeList.add("Interim Stay");
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)CASESTATUS, statusCodeList));
                if (searchRequest.getLcNumber() != null) {
                    boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lcNumber", (Object)searchRequest.getLcNumber()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseFromDate())) {
                    boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)CASE_DATE).gte(newFormat.format(formatter.parse(searchRequest.getCaseFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getCaseToDate())))));
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseFromDate())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)CASE_DATE).gte(newFormat.format(formatter.parse(searchRequest.getCaseFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getCaseToDate())))));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getOfficerIncharge())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)OFFICERINCHRGE, (String)searchRequest.getOfficerIncharge().split("@")[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseCategory())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)CASETYPE, (String)searchRequest.getCaseCategory()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCourtName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)COURTNAME, (String)searchRequest.getCourtName()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseStatus())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)CASESTATUS, (String)searchRequest.getCaseStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCourtType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)COURTTYPE, (String)searchRequest.getCourtType()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getPetitionType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)PETITIONTYPE, (String)searchRequest.getPetitionType()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getJudgmentType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)JUDGEMENTOUTCOME, (String)searchRequest.getJudgmentType()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getStandingCounsel())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)STANDINGCOUNSEL, (String)searchRequest.getStandingCounsel()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getReportStatus())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"subStatus", (String)searchRequest.getReportStatus()));
        }
        return boolQuery;
    }

    public List<LegalCommonReportResult> getEmployeeHearingResult(LegalCommonReportResult legalCommonReport, String reportType) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
        SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
        ArrayList<LegalCommonReportResult> finalResult = new ArrayList<LegalCommonReportResult>();
        List<HearingsDocument> hearingsDocumentList = this.findAllHearingsIndexByFilter(legalCommonReport);
        for (HearingsDocument hearingsDocument : hearingsDocumentList) {
            legalCommonReport.setLcNumber(hearingsDocument.getLcNumber());
            BoolQueryBuilder query = this.getFilterQuery(legalCommonReport, reportType);
            NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"legalcasedocument"}).withQuery((QueryBuilder)query).build();
            Page legalcaseDocumentSearchList = this.legalCaseDocumentRepository.search((SearchQuery)searchQuery);
            if (legalcaseDocumentSearchList == null) continue;
            for (LegalCaseDocument legalcaseDocumentIndex : legalcaseDocumentSearchList) {
                LegalCommonReportResult hearingsDueReportResultObj = new LegalCommonReportResult();
                hearingsDueReportResultObj.setCaseNumber(legalcaseDocumentIndex.getCaseNumber());
                hearingsDueReportResultObj.setLcNumber(legalcaseDocumentIndex.getLcNumber());
                hearingsDueReportResultObj.setCaseTitle(legalcaseDocumentIndex.getCaseTitle());
                hearingsDueReportResultObj.setCaseNumber(legalcaseDocumentIndex.getCaseNumber());
                hearingsDueReportResultObj.setCourtName(legalcaseDocumentIndex.getCourtName());
                hearingsDueReportResultObj.setPetitionerName(legalcaseDocumentIndex.getPetitionerNames());
                hearingsDueReportResultObj.setRespondantName(legalcaseDocumentIndex.getRespondantNames());
                hearingsDueReportResultObj.setStandingCounsel(legalcaseDocumentIndex.getAdvocateName());
                hearingsDueReportResultObj.setOfficerIncharge(legalcaseDocumentIndex.getOfficerIncharge());
                hearingsDueReportResultObj.setNextDate(myFormat.format(dateFormat.parse(legalcaseDocumentIndex.getNextDate().toString())));
                finalResult.add(hearingsDueReportResultObj);
            }
        }
        return finalResult;
    }

    public List<HearingsDocument> findAllHearingsIndexByFilter(LegalCommonReportResult searchRequest) throws ParseException {
        BoolQueryBuilder query = this.getHearingsFilterQuery(searchRequest);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"hearingsdocument"}).withQuery((QueryBuilder)query).withPageable((Pageable)new PageRequest(0, 250)).build();
        Page hearingsDocumentSearchList = this.hearingsDocumentRepository.search((SearchQuery)searchQuery);
        ArrayList<HearingsDocument> hearingsDocumentList = new ArrayList<HearingsDocument>();
        for (HearingsDocument documentObj : hearingsDocumentSearchList) {
            hearingsDocumentList.add(documentObj);
        }
        return hearingsDocumentList;
    }

    private BoolQueryBuilder getHearingsFilterQuery(LegalCommonReportResult searchRequest) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat newFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        BoolQueryBuilder boolQuery = new BoolQueryBuilder();
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"cityName", (String)ApplicationThreadLocals.getCityName()));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseFromDate())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"hearingDate").gte(newFormat.format(formatter.parse(searchRequest.getCaseFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getCaseToDate())))));
        }
        return boolQuery;
    }
}

