/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.DateUtils;
import org.egov.lcms.transactions.entity.LcInterimOrderDocuments;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.egov.lcms.transactions.entity.ReportStatus;
import org.egov.lcms.transactions.repository.LCInterimOrderDocumentsRepository;
import org.egov.lcms.transactions.repository.LegalCaseInterimOrderRepository;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.egov.lcms.transactions.service.LegalCaseSmsService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class LegalCaseInterimOrderService {
    private final LegalCaseInterimOrderRepository legalCaseInterimOrderRepository;
    @Autowired
    private LegalCaseUtil legalCaseUtil;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private LegalCaseSmsService legalCaseSmsService;
    @Autowired
    private LegalCaseService legalCaseService;
    @Autowired
    private LCInterimOrderDocumentsRepository lCInterimOrderDocumentsRepository;

    @Autowired
    public LegalCaseInterimOrderService(LegalCaseInterimOrderRepository legalCaseInterimOrderRepository) {
        this.legalCaseInterimOrderRepository = legalCaseInterimOrderRepository;
    }

    @Transactional
    public LegalCaseInterimOrder persist(LegalCaseInterimOrder legalCaseInterimOrder, MultipartFile[] files) throws IOException, ParseException {
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "INTERIM_STAY");
        legalCaseInterimOrder.getLegalCase().setStatus(statusObj);
        ReportStatus reportStatus = null;
        legalCaseInterimOrder.getLegalCase().setReportStatus(reportStatus);
        this.updateNextDate(legalCaseInterimOrder, legalCaseInterimOrder.getLegalCase());
        LegalCaseInterimOrder savedlcInterimOrder = (LegalCaseInterimOrder)((Object)this.legalCaseInterimOrderRepository.save((Object)legalCaseInterimOrder));
        this.legalCaseSmsService.sendSmsToOfficerInchargeInterimOrder(legalCaseInterimOrder);
        this.legalCaseSmsService.sendSmsToStandingCounselForInterimOrder(legalCaseInterimOrder);
        this.legalCaseService.persistLegalCaseIndex(legalCaseInterimOrder.getLegalCase(), legalCaseInterimOrder, null, null, null);
        List<LcInterimOrderDocuments> documentDetails = this.getDocumentDetails(savedlcInterimOrder, files);
        if (!documentDetails.isEmpty()) {
            savedlcInterimOrder.setLcInterimOrderDocuments(documentDetails);
            this.persistDocuments(documentDetails);
        }
        return savedlcInterimOrder;
    }

    public List<LegalCaseInterimOrder> findAll() {
        return this.legalCaseInterimOrderRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"id"}));
    }

    public LegalCaseInterimOrder findById(Long id) {
        return this.legalCaseInterimOrderRepository.findById(id);
    }

    public List<LcInterimOrderDocuments> getLcInterimOrderDocList(LegalCaseInterimOrder legalCaseInterimOrder) {
        return legalCaseInterimOrder.getLcInterimOrderDocuments();
    }

    public List<LegalCaseInterimOrder> findByLCNumber(String lcNumber) {
        return this.legalCaseInterimOrderRepository.findByLegalCase_lcNumber(lcNumber);
    }

    public void updateNextDate(LegalCaseInterimOrder legalCaseInterimOrder, LegalCase legalCase) {
        if (!DateUtils.compareDates((Date)legalCase.getNextDate(), (Date)legalCaseInterimOrder.getIoDate())) {
            legalCase.setNextDate(legalCaseInterimOrder.getIoDate());
        } else {
            ArrayList<Date> ioDateList = new ArrayList<Date>(0);
            ioDateList.add(legalCaseInterimOrder.getIoDate());
            for (LegalCaseInterimOrder lcinterimorderObj : legalCase.getLegalCaseInterimOrder()) {
                if (lcinterimorderObj.getId().equals(legalCaseInterimOrder.getId())) continue;
                ioDateList.add(lcinterimorderObj.getIoDate());
            }
            legalCase.setNextDate((Date)Collections.max(ioDateList));
        }
    }

    public List<LcInterimOrderDocuments> getDocumentDetails(LegalCaseInterimOrder legalCaseInterimOrder, MultipartFile[] files) throws IOException {
        ArrayList<LcInterimOrderDocuments> documentDetailsList = new ArrayList<LcInterimOrderDocuments>();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isEmpty()) continue;
                LcInterimOrderDocuments applicationDocument = new LcInterimOrderDocuments();
                applicationDocument.setLegalCaseInterimOrder(legalCaseInterimOrder);
                applicationDocument.setDocumentName("LcInterimOrder");
                applicationDocument.setSupportDocs(this.fileStoreService.store(files[i].getInputStream(), files[i].getOriginalFilename(), files[i].getContentType(), "LCMS"));
                documentDetailsList.add(applicationDocument);
            }
        }
        return documentDetailsList;
    }

    public void persistDocuments(List<LcInterimOrderDocuments> documentDetailsList) {
        if (documentDetailsList != null && !documentDetailsList.isEmpty()) {
            for (LcInterimOrderDocuments doc : documentDetailsList) {
                this.lCInterimOrderDocumentsRepository.save((Object)doc);
            }
        }
    }
}

