/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.service.es;

import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.lcms.entity.es.LegalCaseDocument;
import org.egov.lcms.masters.entity.enums.JudgmentImplIsComplied;
import org.egov.lcms.repository.es.LegalCaseDocumentRepository;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseDisposal;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LegalCaseDocumentService {
    private final LegalCaseDocumentRepository legalCaseDocumentRepository;
    @Autowired
    private CityService cityService;

    @Autowired
    public LegalCaseDocumentService(LegalCaseDocumentRepository legalCaseDocumentRepository) {
        this.legalCaseDocumentRepository = legalCaseDocumentRepository;
    }

    public LegalCaseDocument persistLegalCaseDocumentIndex(LegalCase legalCase, LegalCaseInterimOrder legalCaseInterimOrder, Judgment judgment, JudgmentImpl judgmentImpl, LegalCaseDisposal legalCaseDisposal) throws ParseException {
        Map cityInfo = this.cityService.cityDataAsMap();
        LegalCaseDocument legalCaseDocument = null;
        String lcnumber = "\"" + legalCase.getLcNumber() + "\"";
        if (legalCase.getLcNumber() != null) {
            legalCaseDocument = this.legalCaseDocumentRepository.findByLcNumberAndCityCode(lcnumber, ApplicationThreadLocals.getCityCode());
        }
        if (legalCaseDocument != null) {
            this.updateLegalCaseIndex(legalCaseDocument, legalCase, legalCaseInterimOrder, judgment, judgmentImpl, legalCaseDisposal);
        } else {
            legalCaseDocument = LegalCaseDocument.builder().withCaseNumber(legalCase.getCaseNumber()).withLcNumber(legalCase.getLcNumber()).withCaseTitle(legalCase.getCaseTitle()).withCaseDate(legalCase.getCaseDate()).withCaseReceivingDate(legalCase.getCaseReceivingDate()).withCaseType(legalCase.getCaseTypeMaster().getCaseType()).withCourtName(legalCase.getCourtMaster().getName()).withCourtType(legalCase.getCourtMaster().getCourtType().getCourtType()).withPetitionType(legalCase.getPetitionTypeMaster().getPetitionType()).withStatus(legalCase.getStatus().getDescription()).withPetitionerNames(legalCase.getPetitionersNames()).withRespondantNames(legalCase.getRespondantNames()).withNextDate(legalCase.getNextDate()).withPreviousCaseNumber(legalCase.getAppealNum() != null ? legalCase.getAppealNum() : "").withOfficerIncharge(legalCase.getOfficerIncharge() != null ? legalCase.getOfficerIncharge().getName() : "").withSubStatus(legalCase.getReportStatus() != null ? legalCase.getReportStatus().getName() : "").withPwrDueDate(legalCase.getPwrList().get(0).getPwrDueDate()).withCaDueDate(legalCase.getPwrList().get(0).getCaDueDate()).withFiledByULB(legalCase.getIsFiledByCorporation()).withCityName(ApplicationThreadLocals.getCityName()).withCityCode(ApplicationThreadLocals.getCityCode()).withCityGrade(StringUtils.defaultString((String)((String)cityInfo.get("cityGrade")))).withRegionName(StringUtils.defaultString((String)((String)cityInfo.get("cityRegion")))).withDistrictName(StringUtils.defaultString((String)((String)cityInfo.get("districtName")))).withCreatedDate(legalCase.getCaseDate()).build();
            this.createLeglCaseDocument(legalCaseDocument);
        }
        return legalCaseDocument;
    }

    public LegalCaseDocument updateLegalCaseIndex(LegalCaseDocument legalCaseDocument, LegalCase legalCase, LegalCaseInterimOrder legalCaseInterimOrder, Judgment judgment, JudgmentImpl judgmentImpl, LegalCaseDisposal legalCaseDisposal) throws ParseException {
        legalCaseDocument.setCaseDate(legalCase.getCaseDate());
        legalCaseDocument.setCaseReceivingDate(legalCase.getCaseReceivingDate());
        legalCaseDocument.setCaseTitle(legalCase.getCaseTitle());
        legalCaseDocument.setCaseType(legalCase.getCaseTypeMaster().getCaseType());
        legalCaseDocument.setCourtName(legalCase.getCourtMaster().getName());
        legalCaseDocument.setCourtType(legalCase.getCourtMaster().getCourtType().getCourtType());
        legalCaseDocument.setPetitionType(legalCase.getPetitionTypeMaster().getPetitionType());
        legalCaseDocument.setFiledByULB(legalCase.getIsFiledByCorporation());
        legalCaseDocument.setNextDate(legalCase.getNextDate());
        legalCaseDocument.setOfficerIncharge(legalCase.getOfficerIncharge() != null ? legalCase.getOfficerIncharge().getName() : "");
        legalCaseDocument.setPetitionerNames(legalCase.getPetitionersNames());
        legalCaseDocument.setRespondantNames(legalCase.getRespondantNames());
        legalCaseDocument.setPreviousCaseNumber(legalCase.getAppealNum() != null ? legalCase.getAppealNum() : "");
        legalCaseDocument.setStatus(legalCase.getStatus().getDescription());
        legalCaseDocument.setSubStatus(legalCase.getReportStatus() != null ? legalCase.getReportStatus().getName() : "");
        if (legalCase.getPwrList() != null && !legalCase.getPwrList().isEmpty()) {
            legalCaseDocument.setPwrDueDate(legalCase.getPwrList().get(0).getPwrDueDate());
            legalCaseDocument.setCaFilingDate(legalCase.getPwrList().get(0).getCaFilingDate());
            legalCaseDocument.setCaDueDate(legalCase.getPwrList().get(0).getCaDueDate());
        }
        if (legalCase.getLegalCaseAdvocates() != null && !legalCase.getLegalCaseAdvocates().isEmpty()) {
            legalCaseDocument.setAdvocateName(legalCase.getLegalCaseAdvocates().get(0).getAdvocateMaster().getName());
            legalCaseDocument.setSeniorAdvocate(legalCase.getLegalCaseAdvocates().get(0).getAdvocateMaster().getIsSenioradvocate());
        }
        if ("INTERIM_STAY".equalsIgnoreCase(legalCase.getStatus().getCode())) {
            if (!legalCase.getLegalCaseInterimOrder().isEmpty()) {
                legalCaseDocument.setInterimOrderType(legalCase.getLegalCaseInterimOrder().get(0).getInterimOrder().getInterimOrderType());
            } else {
                legalCaseDocument.setInterimOrderType(legalCaseInterimOrder.getInterimOrder().getInterimOrderType());
            }
        }
        if ("JUDGMENT".equalsIgnoreCase(legalCase.getStatus().getCode())) {
            legalCaseDocument.setJudgmentOutcome(judgment.getJudgmentType().getName());
            legalCaseDocument.setJudgmentDate(judgment.getOrderDate());
            legalCaseDocument.setOrderSentToDeptDate(judgment.getSentToDeptOn());
            legalCaseDocument.setDeadLineImplementByDate(judgment.getImplementByDate());
        }
        if ("JUDGEMENT_IMPL".equalsIgnoreCase(legalCase.getStatus().getCode())) {
            legalCaseDocument.setJudgmentImplDate(judgmentImpl.getDateOfCompliance());
            legalCaseDocument.setJudgmentImplemented(judgmentImpl.getJudgmentImplIsComplied().name());
            if (judgmentImpl.getJudgmentImplIsComplied().toString().equals(JudgmentImplIsComplied.NO.toString())) {
                legalCaseDocument.setImplementationFailure(judgmentImpl.getImplementationFailure().name());
            }
        }
        if ("CLOSED".equalsIgnoreCase(legalCase.getStatus().getCode())) {
            legalCaseDocument.setDisposalDate(legalCaseDisposal.getDisposalDate());
        }
        legalCaseDocument.setCreatedDate(legalCase.getCaseDate());
        this.createLeglCaseDocument(legalCaseDocument);
        return legalCaseDocument;
    }

    @Transactional
    public LegalCaseDocument createLeglCaseDocument(LegalCaseDocument legalCaseIndex) {
        this.legalCaseDocumentRepository.save(legalCaseIndex);
        return legalCaseIndex;
    }
}

