/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.masters.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.commons.service.EntityTypeService;
import org.egov.commons.utils.EntityType;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.BusinessUser;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.lcms.autonumber.AdvocateUserNameGenerator;
import org.egov.lcms.masters.entity.AdvocateMaster;
import org.egov.lcms.masters.repository.AdvocateMasterRepository;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvocateMasterService
implements EntityTypeService {
    private final AdvocateMasterRepository advocateMasterRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private AdvocateUserNameGenerator advocateUserNameGenerator;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    @Autowired
    public AdvocateMasterService(AdvocateMasterRepository advocateMasterRepository) {
        this.advocateMasterRepository = advocateMasterRepository;
    }

    @Transactional
    public AdvocateMaster persist(AdvocateMaster advocateMaster) {
        return (AdvocateMaster)((Object)this.advocateMasterRepository.save((Object)advocateMaster));
    }

    public List<AdvocateMaster> findAll() {
        return this.advocateMasterRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public List<AdvocateMaster> getActiveAdvocateMaster() {
        return this.advocateMasterRepository.findByIsActiveTrueOrderByNameAsc();
    }

    public AdvocateMaster findByName(String name) {
        return this.advocateMasterRepository.findByName(name);
    }

    public List<AdvocateMaster> getAllAdvocatesByNameLikeAndIsSeniorAdvocate(String name, Boolean isSeniorAdvocate) {
        return this.advocateMasterRepository.findByNameContainingIgnoreCaseAndIsSeniorAdvocate(name, isSeniorAdvocate);
    }

    public AdvocateMaster findOne(Long id) {
        return (AdvocateMaster)((Object)this.advocateMasterRepository.findOne(id));
    }

    @Transactional
    public void createAccountDetailKey(AdvocateMaster ad) {
        Accountdetailtype accountdetailtype = this.accountdetailtypeHibernateDAO.getAccountdetailtypeByName("lawyer");
        Accountdetailkey accountdetailkey = new Accountdetailkey();
        accountdetailkey.setGroupid(Integer.valueOf(1));
        accountdetailkey.setDetailkey(Integer.valueOf(ad.getId().intValue()));
        accountdetailkey.setDetailname(accountdetailtype.getAttributename());
        accountdetailkey.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(accountdetailkey);
    }

    @Transactional
    public void createAdvocateUser(AdvocateMaster advocateMaster) {
        User user = null;
        if (advocateMaster.getAdvocateUser() != null && advocateMaster.getAdvocateUser().getId() != null) {
            user = this.userService.getUserById(advocateMaster.getAdvocateUser().getId());
        }
        if (user == null) {
            BusinessUser businessUser = new BusinessUser();
            user = this.createNewAdvocateUser(advocateMaster, businessUser);
            advocateMaster.setAdvocateUser(user);
        } else {
            user.setMobileNumber(advocateMaster.getMobileNumber());
            user.setEmailId(advocateMaster.getEmail() != null ? advocateMaster.getEmail() : "");
            user.setName(advocateMaster.getName());
            user.setSalutation(advocateMaster.getSalutation());
            user.setPan(advocateMaster.getPanNumber());
            advocateMaster.setAdvocateUser(user);
        }
    }

    private User createNewAdvocateUser(AdvocateMaster advocateMaster, BusinessUser businessUser) {
        businessUser.setMobileNumber(advocateMaster.getMobileNumber());
        businessUser.setEmailId(advocateMaster.getEmail() != null ? advocateMaster.getEmail() : "");
        businessUser.setName(advocateMaster.getName());
        businessUser.setSalutation(advocateMaster.getSalutation());
        businessUser.setPassword(this.passwordEncoder.encode((CharSequence)advocateMaster.getMobileNumber()));
        businessUser.setPwdExpiryDate(DateTime.now().plusMonths(12).toDate());
        businessUser.setPan(advocateMaster.getPanNumber());
        businessUser.setActive(true);
        businessUser.setUsername(this.advocateUserNameGenerator.generateAdvocateUserName(advocateMaster));
        businessUser.setRoles(this.getRolesForStandingCounsel());
        return this.userService.createUser((User)businessUser);
    }

    public Set<Role> getRolesForStandingCounsel() {
        HashSet<Role> roles = new HashSet<Role>();
        List appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKey("LCMS", "STANDINGCOUNSEL_ROLES");
        for (AppConfigValues appConfig : appConfigValueList) {
            roles.add(this.roleService.getRoleByName(appConfig.getValue()));
        }
        return roles;
    }

    public List<AdvocateMaster> search(AdvocateMaster advocateMaster) {
        List resultList;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(AdvocateMaster.class);
        Root advocateMasterObj = createQuery.from(AdvocateMaster.class);
        createQuery.select((Selection)advocateMasterObj);
        Metamodel m = this.entityManager.getMetamodel();
        javax.persistence.metamodel.EntityType AdvocateMaster2 = m.entity(AdvocateMaster.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (advocateMaster.getName() == null && advocateMaster.getMobileNumber() == null && advocateMaster.getEmail() == null) {
            resultList = this.findAll();
        } else {
            if (advocateMaster.getName() != null) {
                String name = "%" + advocateMaster.getName().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)advocateMasterObj.get("name")));
                predicates.add(cb.like(cb.lower((Expression)advocateMasterObj.get(AdvocateMaster2.getDeclaredSingularAttribute("name", String.class))), name));
            }
            if (advocateMaster.getMobileNumber() != null) {
                String mobileNumber = "%" + advocateMaster.getMobileNumber() + "%";
                predicates.add(cb.isNotNull((Expression)advocateMasterObj.get("mobileNumber")));
                predicates.add(cb.like(cb.lower((Expression)advocateMasterObj.get(AdvocateMaster2.getDeclaredSingularAttribute("mobileNumber", String.class))), mobileNumber));
            }
            if (advocateMaster.getEmail() != null) {
                String email = "%" + advocateMaster.getEmail() + "%";
                predicates.add(cb.isNotNull((Expression)advocateMasterObj.get("email")));
                predicates.add(cb.like(cb.lower((Expression)advocateMasterObj.get(AdvocateMaster2.getDeclaredSingularAttribute("email", String.class))), email));
            }
            createQuery.where(predicates.toArray(new Predicate[0]));
            TypedQuery query = this.entityManager.createQuery(createQuery);
            resultList = query.getResultList();
        }
        return resultList;
    }

    public List<EntityType> getAllActiveEntities(Integer advocateId) {
        ArrayList<EntityType> entities = new ArrayList<EntityType>();
        List<AdvocateMaster> advocateNames = this.getActiveAdvocateMaster();
        entities.addAll(advocateNames);
        return entities;
    }

    public List<? extends EntityType> filterActiveEntities(String filterKey, int maxRecords, Integer accountDetailTypeId) {
        return this.advocateMasterRepository.findByNameLike(filterKey + "%");
    }

    public List getAssetCodesForProjectCode(Integer accountdetailkey) throws ValidationException {
        return null;
    }

    public List<AdvocateMaster> validateEntityForRTGS(List<Long> idsList) throws ValidationException {
        return null;
    }

    public List<AdvocateMaster> getEntitiesById(List<Long> idsList) throws ValidationException {
        return null;
    }
}

