/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.DateUtils;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.JudgmentDocuments;
import org.egov.lcms.transactions.entity.ReportStatus;
import org.egov.lcms.transactions.repository.JudgmentDocumentsRepository;
import org.egov.lcms.transactions.repository.JudgmentRepository;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.egov.lcms.transactions.service.LegalCaseSmsService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class JudgmentService {
    @Autowired
    private final JudgmentRepository judgmentRepository;
    @Autowired
    private LegalCaseUtil legalCaseUtil;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private LegalCaseSmsService legalCaseSmsService;
    @Autowired
    private LegalCaseService legalCaseService;
    @Autowired
    private JudgmentDocumentsRepository judgmentDocumentsRepository;

    @Autowired
    public JudgmentService(JudgmentRepository judgmentRepository) {
        this.judgmentRepository = judgmentRepository;
    }

    @Transactional
    public Judgment persist(Judgment judgment, MultipartFile[] files) throws IOException, ParseException {
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "JUDGMENT");
        judgment.getLegalCase().setStatus(statusObj);
        ReportStatus reportStatus = null;
        judgment.getLegalCase().setReportStatus(reportStatus);
        Judgment savedjudgment = (Judgment)((Object)this.judgmentRepository.save((Object)judgment));
        this.legalCaseSmsService.sendSmsToOfficerInchargeForJudgment(judgment);
        this.legalCaseSmsService.sendSmsToStandingCounselForJudgment(judgment);
        this.legalCaseService.persistLegalCaseIndex(savedjudgment.getLegalCase(), null, savedjudgment, null, null);
        List<JudgmentDocuments> documentDetails = this.getDocumentDetails(savedjudgment, files);
        if (!documentDetails.isEmpty()) {
            savedjudgment.setJudgmentDocuments(documentDetails);
            this.persistDocuments(documentDetails);
        }
        return savedjudgment;
    }

    public List<Judgment> findAll() {
        return this.judgmentRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{""}));
    }

    public Judgment findById(Long id) {
        return (Judgment)((Object)this.judgmentRepository.findOne(id));
    }

    public List<JudgmentDocuments> getJudgmentDocList(Judgment judgment) {
        return judgment.getJudgmentDocuments();
    }

    public Judgment findByLCNumber(String lcNumber) {
        return this.judgmentRepository.findByLegalCase_lcNumber(lcNumber);
    }

    public void updateNextDate(Judgment judgment) {
        Date nextDate;
        Date date = nextDate = judgment.getEnquiryDate() != null ? judgment.getEnquiryDate() : judgment.getOrderDate();
        if (!DateUtils.compareDates((Date)judgment.getLegalCase().getNextDate(), (Date)nextDate)) {
            judgment.getLegalCase().setNextDate(nextDate);
        } else if (judgment.getEnquiryDate() != null) {
            judgment.getLegalCase().setNextDate(judgment.getEnquiryDate());
        } else {
            judgment.getLegalCase().setNextDate(judgment.getOrderDate());
        }
    }

    public List<JudgmentDocuments> getDocumentDetails(Judgment judgment, MultipartFile[] files) throws IOException {
        ArrayList<JudgmentDocuments> documentDetailsList = new ArrayList<JudgmentDocuments>();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isEmpty()) continue;
                JudgmentDocuments applicationDocument = new JudgmentDocuments();
                applicationDocument.setJudgment(judgment);
                applicationDocument.setDocumentName("Judgment");
                applicationDocument.setSupportDocs(this.fileStoreService.store(files[i].getInputStream(), files[i].getOriginalFilename(), files[i].getContentType(), "LCMS"));
                documentDetailsList.add(applicationDocument);
            }
        }
        return documentDetailsList;
    }

    public void persistDocuments(List<JudgmentDocuments> documentDetailsList) {
        if (documentDetailsList != null && !documentDetailsList.isEmpty()) {
            for (JudgmentDocuments doc : documentDetailsList) {
                this.judgmentDocumentsRepository.save((Object)doc);
            }
        }
    }
}

