/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.autonumber.impl;

import java.io.Serializable;
import java.util.Date;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.lcms.autonumber.LegalCaseNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LegalCaseNumberGeneratorImpl
implements LegalCaseNumberGenerator {
    private static final String LEGALCASE_NUMBER_SEQ_PREFIX = "SEQ_LEGALCASE_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    @Override
    public String generateLegalCaseNumber() {
        String sequenceName = LEGALCASE_NUMBER_SEQ_PREFIX;
        CFinancialYear finYear = this.financialYearDAO.getFinancialYearByDate(new Date());
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(LEGALCASE_NUMBER_SEQ_PREFIX);
        return String.format("%s%s%s%06d", "LC/", ApplicationThreadLocals.getCityCode() + "/", finYear != null ? finYear.getFinYearRange().split("-")[0] + "/" : "/", nextSequence);
    }
}

