/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.text.ParseException;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.lcms.transactions.entity.LegalCaseDisposal;
import org.egov.lcms.transactions.entity.ReportStatus;
import org.egov.lcms.transactions.repository.LegalCaseDisposalRepository;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.egov.lcms.transactions.service.LegalCaseSmsService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LegalCaseDisposalService {
    @Autowired
    private LegalCaseDisposalRepository legalCaseDisposalRepository;
    @Autowired
    private LegalCaseUtil legalCaseUtil;
    @Autowired
    private LegalCaseSmsService legalCaseSmsService;
    @Autowired
    private LegalCaseService legalCaseService;

    @Transactional
    public LegalCaseDisposal persist(LegalCaseDisposal legalCaseDisposal) throws ParseException {
        legalCaseDisposal.getLegalCase().setNextDate(legalCaseDisposal.getDisposalDate());
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "CLOSED");
        legalCaseDisposal.getLegalCase().setStatus(statusObj);
        ReportStatus reportStatus = null;
        legalCaseDisposal.getLegalCase().setReportStatus(reportStatus);
        this.legalCaseSmsService.sendSmsToOfficerInchargeForCloseCase(legalCaseDisposal);
        this.legalCaseSmsService.sendSmsToStandingCounselForCloseCase(legalCaseDisposal);
        this.legalCaseService.persistLegalCaseIndex(legalCaseDisposal.getLegalCase(), null, null, null, legalCaseDisposal);
        return (LegalCaseDisposal)((Object)this.legalCaseDisposalRepository.save((Object)legalCaseDisposal));
    }

    public List<LegalCaseDisposal> findAll() {
        return this.legalCaseDisposalRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{""}));
    }

    public LegalCaseDisposal findById(Long id) {
        return (LegalCaseDisposal)((Object)this.legalCaseDisposalRepository.findOne(id));
    }
}

