/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.lcms.entity.es.LegalCaseDocument;
import org.egov.lcms.reports.entity.LcDueReportResult;
import org.egov.lcms.repository.es.LegalCaseDocumentRepository;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LcDueReportService {
    @Autowired
    private LegalCaseDocumentRepository legalCaseDocumentRepository;

    public void buildLcDueReport(LegalCaseDocument legalcaseDocument, List<LcDueReportResult> finalResult) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
        SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
        LcDueReportResult dueReportResultObj = new LcDueReportResult();
        dueReportResultObj.setCaseNumber(legalcaseDocument.getCaseNumber());
        dueReportResultObj.setLcNumber(legalcaseDocument.getLcNumber());
        dueReportResultObj.setCaseTitle(legalcaseDocument.getCaseTitle());
        dueReportResultObj.setCaseNumber(legalcaseDocument.getCaseNumber());
        dueReportResultObj.setCourtName(legalcaseDocument.getCourtName());
        dueReportResultObj.setPetName(legalcaseDocument.getPetitionerNames());
        dueReportResultObj.setResName(legalcaseDocument.getRespondantNames());
        dueReportResultObj.setStandingCounsel(legalcaseDocument.getAdvocateName());
        dueReportResultObj.setOfficerIncharge(legalcaseDocument.getOfficerIncharge());
        dueReportResultObj.setNextDate(myFormat.format(dateFormat.parse(legalcaseDocument.getNextDate().toString())));
        finalResult.add(dueReportResultObj);
    }

    public List<LegalCaseDocument> findAllLegalcaseDocumentIndexByFilter(LcDueReportResult dueReportResult, String reportType) throws ParseException {
        BoolQueryBuilder query = this.getFilterQuery(dueReportResult, reportType);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"legalcasedocument"}).withQuery((QueryBuilder)query).withPageable((Pageable)new PageRequest(0, 250)).build();
        Page legalcaseDocumentSearchList = this.legalCaseDocumentRepository.search((SearchQuery)searchQuery);
        ArrayList<LegalCaseDocument> legalcaseDocumentList = new ArrayList<LegalCaseDocument>();
        for (LegalCaseDocument documentObj : legalcaseDocumentSearchList) {
            legalcaseDocumentList.add(documentObj);
        }
        return legalcaseDocumentList;
    }

    private BoolQueryBuilder getFilterQuery(LcDueReportResult searchRequest, String reportType) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat newFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"cityName", (String)ApplicationThreadLocals.getCityName()));
        if (reportType.equals("PWR due date")) {
            boolQuery.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"pwrDueDate"));
        } else if (reportType.equals("CA Due date")) {
            boolQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)"caDueDate"));
        } else if (reportType.equals("Judgement Implementation")) {
            boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Closed"));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getFromDate()) && !reportType.equals("Judgement Implementation")) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"caseDate").gte(newFormat.format(formatter.parse(searchRequest.getFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getToDate())))));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getOfficerIncharge())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"officerIncharge", (String)searchRequest.getOfficerIncharge().split("@")[0]));
        }
        if (reportType.equals("Judgement Implementation") && StringUtils.isNotBlank((CharSequence)searchRequest.getFromDate())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"judgmentImplDate").gte(newFormat.format(formatter.parse(searchRequest.getFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getToDate())))));
        }
        return boolQuery;
    }
}

