/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.egov.lcms.reports.entity.GenericSubReportResult;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class GenericSubReportService {
    @Autowired
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<GenericSubReportResult> getGenericSubReport(GenericSubReportResult genericSubReportResult, Boolean clickOnCount) {
        StringBuilder queryStr = new StringBuilder();
        if (genericSubReportResult.getAggregatedBy() != null) {
            if (genericSubReportResult.getAggregatedBy().equals("Court Name")) {
                this.getAggregateQueryByCourtName(genericSubReportResult, queryStr, clickOnCount);
            }
            if (genericSubReportResult.getAggregatedBy().equals("Court Type")) {
                this.getAggregateQueryByCourtType(genericSubReportResult, queryStr, clickOnCount);
            }
            if (genericSubReportResult.getAggregatedBy().equals("Petition Type")) {
                this.getAggregateQueryByPetitionType(genericSubReportResult, queryStr, clickOnCount);
            }
            if (genericSubReportResult.getAggregatedBy().equals("Case Status")) {
                this.getAggregateQueryByCaseStatus(genericSubReportResult, queryStr, clickOnCount);
            }
            if (genericSubReportResult.getAggregatedBy().equals("In charge officer")) {
                this.getAggregateQueryByOfficerIncharge(genericSubReportResult, queryStr, clickOnCount);
            }
            if (genericSubReportResult.getAggregatedBy().equals("Judgment outcome")) {
                this.getAggregateQueryByJudgementOutcome(genericSubReportResult, queryStr, clickOnCount);
            }
            if (genericSubReportResult.getAggregatedBy().equals("Case Category")) {
                this.getAggregateQueryByCaseCategory(genericSubReportResult, queryStr, clickOnCount);
            }
        } else {
            this.getLegalCaseSubReportStatus(genericSubReportResult, queryStr, clickOnCount);
            this.getAppendQuery(genericSubReportResult, queryStr);
        }
        Query queryResult = this.getCurrentSession().createQuery(queryStr.toString());
        queryResult = this.setParameterToQuery(genericSubReportResult, queryResult, clickOnCount);
        List genericSubReportResultList = queryResult.list();
        return genericSubReportResultList;
    }

    private Query setParameterToQuery(GenericSubReportResult genericSubReportResultObj, Query queryResult, Boolean clickOnCount) {
        if (clickOnCount.booleanValue()) {
            queryResult.setString("aggreagatedByValue", genericSubReportResultObj.getAggregatedByValue());
        }
        queryResult.setString("moduleType", "Legal Case");
        if (genericSubReportResultObj.getFromDate() != null) {
            queryResult.setDate("fromDate", genericSubReportResultObj.getFromDate());
        }
        if (genericSubReportResultObj.getToDate() != null) {
            queryResult.setDate("toDate", genericSubReportResultObj.getToDate());
        }
        if (genericSubReportResultObj.getCourtId() != null) {
            queryResult.setInteger("courtName", genericSubReportResultObj.getCourtId().intValue());
        }
        if (genericSubReportResultObj.getCourtType() != null) {
            queryResult.setInteger("courtType", genericSubReportResultObj.getCourtType().intValue());
        }
        if (genericSubReportResultObj.getPetitionTypeId() != null) {
            queryResult.setInteger("petitionType", genericSubReportResultObj.getPetitionTypeId().intValue());
        }
        if (genericSubReportResultObj.getCaseStatus() != null) {
            queryResult.setString("status", genericSubReportResultObj.getCaseStatus());
        }
        if (genericSubReportResultObj.getOfficerIncharge() != null) {
            queryResult.setLong("officerIncharge", genericSubReportResultObj.getOfficerIncharge().longValue());
        }
        if (genericSubReportResultObj.getJudgmentTypeId() != null) {
            queryResult.setInteger("judgmentType", genericSubReportResultObj.getJudgmentTypeId().intValue());
        }
        if (StringUtils.isNotBlank((String)genericSubReportResultObj.getStandingCounsel())) {
            queryResult.setString("standingCouncil", genericSubReportResultObj.getStandingCounsel());
        }
        if (genericSubReportResultObj.getOfficerIncharge() != null) {
            queryResult.setLong("officerIncharge", genericSubReportResultObj.getOfficerIncharge().longValue());
        }
        if (genericSubReportResultObj.getCasecategoryId() != null) {
            queryResult.setInteger("caseType", genericSubReportResultObj.getCasecategoryId().intValue());
        }
        if (genericSubReportResultObj.getReportStatusId() != null) {
            queryResult.setInteger("casesubStatus", genericSubReportResultObj.getReportStatusId().intValue());
        }
        queryResult.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(GenericSubReportResult.class));
        return queryResult;
    }

    private void getAppendQuery(GenericSubReportResult genericSubReportResult, StringBuilder queryStr) {
        if (genericSubReportResult.getFromDate() != null) {
            queryStr.append("  and legalcase.caseDate >=:fromDate  ");
        }
        if (genericSubReportResult.getToDate() != null) {
            queryStr.append(" and legalcase.caseDate <=:toDate ");
        }
        if (StringUtils.isNotBlank((String)genericSubReportResult.getStandingCounsel())) {
            queryStr.append(" and legalcase.oppPartyAdvocate =:standingCouncil ");
        }
        if (genericSubReportResult.getOfficerIncharge() != null) {
            queryStr.append(" and position.id =:officerIncharge ");
        }
        if (genericSubReportResult.getCaseStatus() != null) {
            queryStr.append(" and egwStatus.code =:status ");
        }
        if (genericSubReportResult.getCourtType() != null) {
            queryStr.append(" and courtmaster.courtType.id =:courtType ");
        }
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" and judgment.judgmentType.id =:judgmentType ");
        }
        if (genericSubReportResult.getPetitionTypeId() != null) {
            queryStr.append(" and petmaster.id =:petitionType ");
        }
        if (genericSubReportResult.getCasecategoryId() != null) {
            queryStr.append(" and casetypemaster.id =:caseType ");
        }
        if (genericSubReportResult.getCourtId() != null) {
            queryStr.append(" and courtmaster.id =:courtName ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" and reportStatus.id =:casesubStatus ");
        }
    }

    private void getAggregateQueryByCourtName(GenericSubReportResult genericSubReportResult, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append(" SELECT COUNT(DISTINCT legalcase.id) as noOfCase ");
        } else {
            queryStr.append(" select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",courtmaster.name  as aggregatedBy ");
        queryStr.append(" from LegalCase legalcase,CourtMaster courtmaster  ");
        queryStr.append(" ,CaseTypeMaster casetypemaster , PetitionTypeMaster petmaster,EgwStatus egwStatus ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" ,Judgment judgment ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" ,ReportStatus reportStatus ");
        }
        queryStr.append(" where legalcase.courtMaster.id=courtmaster.id and ");
        queryStr.append("  legalcase.caseTypeMaster.id=casetypemaster.id and legalcase.petitionTypeMaster.id=petmaster.id ");
        queryStr.append(" and legalcase.status.id=egwStatus.id and egwStatus.moduletype =:moduleType  ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" and legalcase.id = judgment.legalCase ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" and legalcase.reportStatus.id=reportStatus.id ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" and legalcase.courtMaster.name=:aggreagatedByValue ");
        }
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by courtmaster.name");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" ,legalcase");
        }
        queryStr.append(" order by courtmaster.name");
    }

    private void getAggregateQueryByPetitionType(GenericSubReportResult genericSubReportResult, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append(" SELECT COUNT(DISTINCT legalcase.id) as noOfCase ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",petmaster.petitionType as aggregatedBy ");
        queryStr.append("from LegalCase legalcase,CourtMaster courtmaster  ");
        queryStr.append(" , CaseTypeMaster casetypemaster , PetitionTypeMaster petmaster,EgwStatus egwStatus ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" ,Judgment judgment ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" ,ReportStatus reportStatus ");
        }
        queryStr.append(" where legalcase.petitionTypeMaster.id=petmaster.id  and ");
        queryStr.append("  legalcase.caseTypeMaster.id=casetypemaster.id  and legalcase.courtMaster.id=courtmaster.id ");
        queryStr.append(" and legalcase.status.id=egwStatus.id and egwStatus.moduletype =:moduleType  ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" and legalcase.id = judgment.legalCase ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" and legalcase.reportStatus.id=reportStatus.id ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append("and legalcase.petitionTypeMaster.petitionType=:aggreagatedByValue ");
        }
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by petmaster.petitionType");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" ,legalcase");
        }
        queryStr.append(" order by petmaster.petitionType");
    }

    private void getAggregateQueryByCourtType(GenericSubReportResult genericSubReportResult, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append(" SELECT COUNT(DISTINCT legalcase.id) as noOfCase ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",courtmaster.courtType.courtType  as aggregatedBy ");
        queryStr.append("from LegalCase legalcase,CourtMaster courtmaster ");
        queryStr.append(" , CaseTypeMaster casetypemaster , PetitionTypeMaster petmaster,EgwStatus egwStatus ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" ,Judgment judgment ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" ,ReportStatus reportStatus ");
        }
        queryStr.append(" where legalcase.courtMaster.id=courtmaster.id and legalcase.petitionTypeMaster.id=petmaster.id  ");
        queryStr.append(" and legalcase.caseTypeMaster.id=casetypemaster.id  ");
        queryStr.append(" and legalcase.status.id=egwStatus.id and egwStatus.moduletype =:moduleType ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append("  and legalcase.id = judgment.legalCase ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" and legalcase.reportStatus.id=reportStatus.id ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" and legalcase.courtMaster.courtType.courtType=:aggreagatedByValue ");
        }
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by courtmaster.courtType.courtType");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" ,legalcase");
        }
        queryStr.append(" order by courtmaster.courtType.courtType");
    }

    private void getAggregateQueryByCaseStatus(GenericSubReportResult genericSubReportResult, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append(" SELECT COUNT(DISTINCT legalcase.id) as noOfCase ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",egwStatus.description  as aggregatedBy ");
        queryStr.append("from LegalCase legalcase,EgwStatus egwStatus ");
        queryStr.append(" ,CourtMaster courtmaster ,CaseTypeMaster casetypemaster , PetitionTypeMaster petmaster ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" ,Judgment judgment ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" ,ReportStatus reportStatus ");
        }
        queryStr.append(" where legalcase.courtMaster.id=courtmaster.id and legalcase.petitionTypeMaster.id=petmaster.id ");
        queryStr.append(" and legalcase.caseTypeMaster.id=casetypemaster.id ");
        queryStr.append(" and  legalcase.status.id=egwStatus.id and egwStatus.moduletype =:moduleType ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" and legalcase.id = judgment.legalCase ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" and legalcase.reportStatus.id=reportStatus.id ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" and egwStatus.description=:aggreagatedByValue ");
        }
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by egwStatus.description");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" ,legalcase");
        }
        queryStr.append(" order by egwStatus.description");
    }

    private void getAggregateQueryByOfficerIncharge(GenericSubReportResult genericSubReportResult, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append(" SELECT COUNT(DISTINCT legalcase.id) as noOfCase ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",position.name as aggregatedBy ");
        queryStr.append("from LegalCase legalcase,EgwStatus egwStatus, Position position ");
        queryStr.append(" ,CourtMaster courtmaster ,CaseTypeMaster casetypemaster , PetitionTypeMaster petmaster ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" ,Judgment judgment ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" ,ReportStatus reportStatus ");
        }
        queryStr.append(" where legalcase.courtMaster.id=courtmaster.id and legalcase.petitionTypeMaster.id=petmaster.id ");
        queryStr.append("  and legalcase.caseTypeMaster.id=casetypemaster.id  ");
        queryStr.append(" and  legalcase.status.id=egwStatus.id and egwStatus.moduletype =:moduleType ");
        queryStr.append(" and  legalcase.officerIncharge=position.id ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" and legalcase.id = judgment.legalCase ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" and legalcase.reportStatus.id=reportStatus.id ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append("and position.name=:aggreagatedByValue ");
        }
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by position.name");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" ,legalcase");
        }
        queryStr.append(" order by position.name");
    }

    private void getAggregateQueryByJudgementOutcome(GenericSubReportResult genericSubReportResult, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append(" SELECT COUNT(DISTINCT legalcase.id) as noOfCase ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",judgment.judgmentType.name  as aggregatedBy ");
        queryStr.append(" from LegalCase legalcase,Judgment judgment  ");
        queryStr.append(" ,CourtMaster courtmaster ,CaseTypeMaster casetypemaster , PetitionTypeMaster petmaster,EgwStatus egwStatus ");
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" ,ReportStatus reportStatus ");
        }
        queryStr.append(" where legalcase.id = judgment.legalCase and ");
        queryStr.append("  legalcase.courtMaster.id=courtmaster.id and legalcase.petitionTypeMaster.id=petmaster.id ");
        queryStr.append(" and  legalcase.caseTypeMaster.id=casetypemaster.id ");
        queryStr.append(" and legalcase.status.id=egwStatus.id and egwStatus.moduletype =:moduleType ");
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" and legalcase.reportStatus.id=reportStatus.id ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" and judgment.judgmentType.name=:aggreagatedByValue ");
        }
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by judgment.judgmentType.name");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" ,legalcase");
        }
        queryStr.append(" order by judgment.judgmentType.name");
    }

    private void getAggregateQueryByCaseCategory(GenericSubReportResult genericSubReportResult, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append(" SELECT COUNT(DISTINCT legalcase.id) as noOfCase ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",casetypemaster.caseType as aggregatedBy ");
        queryStr.append("from LegalCase legalcase,CaseTypeMaster casetypemaster ");
        queryStr.append(" ,CourtMaster courtmaster , PetitionTypeMaster petmaster,EgwStatus egwStatus ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" ,Judgment judgment ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" ,ReportStatus reportStatus ");
        }
        queryStr.append(" where legalcase.caseTypeMaster.id=casetypemaster.id ");
        queryStr.append(" and legalcase.courtMaster.id=courtmaster.id and legalcase.petitionTypeMaster.id=petmaster.id ");
        queryStr.append(" and legalcase.status.id=egwStatus.id and egwStatus.moduletype =:moduleType ");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" and legalcase.id = judgment.legalCase ");
        }
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append(" and legalcase.reportStatus.id=reportStatus.id ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" and legalcase.caseTypeMaster.caseType=:aggreagatedByValue ");
        }
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by casetypemaster.caseType");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" ,legalcase");
        }
        queryStr.append(" order by casetypemaster.caseType");
    }

    public void getLegalCaseSubReportStatus(GenericSubReportResult genericSubReportResult, StringBuilder queryStr, Boolean clickOnCount) {
        queryStr.append("select distinct legalcase  as  legalCase ,courtmaster.name  as  courtName ,");
        queryStr.append(" egwStatus.code  as  caseStatus ");
        queryStr.append(" from LegalCase legalcase left join legalcase.officerIncharge position,CourtMaster courtmaster,CaseTypeMaster casetypemaster,");
        queryStr.append(" PetitionTypeMaster petmaster,EgwStatus egwStatus,ReportStatus reportStatus");
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" ,Judgment judgment ");
        }
        queryStr.append(" where legalcase.courtMaster.id=courtmaster.id and ");
        queryStr.append(" legalcase.caseTypeMaster.id=casetypemaster.id and legalcase.petitionTypeMaster.id=petmaster.id and ");
        queryStr.append(" legalcase.status.id=egwStatus.id and egwStatus.moduletype =:moduleType  ");
        if (genericSubReportResult.getReportStatusId() != null) {
            queryStr.append("  and legalcase.reportStatus.id = reportStatus.id ");
        }
        if (genericSubReportResult.getJudgmentTypeId() != null) {
            queryStr.append(" and legalcase.id = judgment.legalCase ");
        }
    }
}

