/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.masters.entity.JudgmentType;
import org.egov.lcms.transactions.entity.JudgmentDocuments;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.egov.lcms.transactions.entity.LegalCase;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_JUDGMENT")
@SequenceGenerator(name="SEQ_EGLC_JUDGMENT", sequenceName="SEQ_EGLC_JUDGMENT", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class Judgment
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_JUDGMENT = "SEQ_EGLC_JUDGMENT";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_JUDGMENT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="legalcase", nullable=false)
    @Audited
    private LegalCase legalCase;
    @ManyToOne
    @NotNull
    @JoinColumn(name="judgmenttype", nullable=false)
    @Audited
    private JudgmentType judgmentType;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy")
    @Column(name="orderdate")
    @Audited
    private Date orderDate;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy")
    @Column(name="senttodepton")
    @Audited
    private Date sentToDeptOn;
    @Column(name="implementbydate")
    @Temporal(value=TemporalType.DATE)
    @Audited
    private Date implementByDate;
    @Column(name="costawarded")
    @Audited
    private double costAwarded;
    @Column(name="compensationAwarded")
    @Audited
    private double compensationAwarded;
    @NotNull
    @Length(max=1024)
    @Column(name="judgmentdetails")
    @Audited
    private String judgmentDetails;
    @Column(name="advisorfee")
    @Audited
    private Double advisorFee;
    @Column(name="arbitratorfee")
    @Audited
    private Double arbitratorFee;
    @Length(max=1024)
    @Column(name="enquirydetails")
    @Audited
    private String enquiryDetails;
    @Temporal(value=TemporalType.DATE)
    @Column(name="enquirydate")
    private Date enquiryDate;
    @Temporal(value=TemporalType.DATE)
    @Column(name="setasidepetitiondate")
    @Audited
    private Date setasidePetitionDate;
    @Length(max=1024)
    @Column(name="setasidepetitiondetails")
    @Audited
    private String setasidePetitionDetails;
    @Temporal(value=TemporalType.DATE)
    @Column(name="saphearingdate")
    @Audited
    private Date sapHearingDate;
    @Column(name="issapaccepted")
    @Audited
    private boolean sapAccepted;
    @ManyToOne
    @JoinColumn(name="parent")
    @Fetch(value=FetchMode.SELECT)
    private Judgment parent;
    @OneToMany(mappedBy="judgment", fetch=FetchType.LAZY)
    @NotAudited
    private List<JudgmentDocuments> judgmentDocuments = new ArrayList<JudgmentDocuments>(0);
    @OneToMany(mappedBy="judgment", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Audited
    private List<JudgmentImpl> judgmentImpl = new ArrayList<JudgmentImpl>(0);
    @OneToMany(cascade={CascadeType.REMOVE})
    @JoinColumn(name="parent")
    @Fetch(value=FetchMode.SELECT)
    @JsonIgnore
    private Set<Judgment> children = new HashSet<Judgment>();
    @Column(name="ismemorequired")
    @Audited
    private boolean isMemoRequired;
    @Column(name="certifiedmemofwddate")
    @Audited
    private Date certifiedMemoFwdDate;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<JudgmentDocuments> getJudgmentDocuments() {
        return this.judgmentDocuments;
    }

    public void setJudgmentDocuments(List<JudgmentDocuments> judgmentDocuments) {
        this.judgmentDocuments = judgmentDocuments;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }

    public JudgmentType getJudgmentType() {
        return this.judgmentType;
    }

    public void setJudgmentType(JudgmentType newJudgmentType) {
        this.judgmentType = newJudgmentType;
    }

    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public Date getSentToDeptOn() {
        return this.sentToDeptOn;
    }

    public void setSentToDeptOn(Date sentToDeptOn) {
        this.sentToDeptOn = sentToDeptOn;
    }

    public Date getImplementByDate() {
        return this.implementByDate;
    }

    public void setImplementByDate(Date implementByDate) {
        this.implementByDate = implementByDate;
    }

    public double getCostAwarded() {
        return this.costAwarded;
    }

    public void setCostAwarded(double costAwarded) {
        this.costAwarded = costAwarded;
    }

    public double getCompensationAwarded() {
        return this.compensationAwarded;
    }

    public void setCompensationAwarded(double compensationAwarded) {
        this.compensationAwarded = compensationAwarded;
    }

    public Set<Judgment> getChildren() {
        return this.children;
    }

    public void setChildren(Set<Judgment> children) {
        this.children = children;
    }

    public void setMemoRequired(boolean isMemoRequired) {
        this.isMemoRequired = isMemoRequired;
    }

    public String getJudgmentDetails() {
        return this.judgmentDetails;
    }

    public void setJudgmentDetails(String judgmentDetails) {
        this.judgmentDetails = judgmentDetails;
    }

    public Double getAdvisorFee() {
        return this.advisorFee;
    }

    public void setAdvisorFee(Double advisorFee) {
        this.advisorFee = advisorFee;
    }

    public Double getArbitratorFee() {
        return this.arbitratorFee;
    }

    public void setArbitratorFee(Double arbitratorFee) {
        this.arbitratorFee = arbitratorFee;
    }

    public Date getSetasidePetitionDate() {
        return this.setasidePetitionDate;
    }

    public void setSetasidePetitionDate(Date setasidePetitionDate) {
        this.setasidePetitionDate = setasidePetitionDate;
    }

    public String getSetasidePetitionDetails() {
        return this.setasidePetitionDetails;
    }

    public void setSetasidePetitionDetails(String setasidePetitionDetails) {
        this.setasidePetitionDetails = setasidePetitionDetails;
    }

    public Date getSapHearingDate() {
        return this.sapHearingDate;
    }

    public boolean getSapAccepted() {
        return this.sapAccepted;
    }

    public void setSapHearingDate(Date sapHearingDate) {
        this.sapHearingDate = sapHearingDate;
    }

    public void setSapAccepted(boolean sapAccepted) {
        this.sapAccepted = sapAccepted;
    }

    public List<JudgmentImpl> getJudgmentImpl() {
        return this.judgmentImpl;
    }

    public void setJudgmentImpl(List<JudgmentImpl> judgmentImpl) {
        this.judgmentImpl = judgmentImpl;
    }

    public void addJudgmentimpl(JudgmentImpl judgmentimpl) {
        this.getJudgmentImpl().add(judgmentimpl);
    }

    public Judgment getParent() {
        return this.parent;
    }

    public void setParent(Judgment parent) {
        this.parent = parent;
    }

    public void setIsMemoRequired(boolean isMemoRequired) {
        this.isMemoRequired = isMemoRequired;
    }

    public boolean getIsMemoRequired() {
        return this.isMemoRequired;
    }

    public Date getCertifiedMemoFwdDate() {
        return this.certifiedMemoFwdDate;
    }

    public void setCertifiedMemoFwdDate(Date certifiedMemoFwdDate) {
        this.certifiedMemoFwdDate = certifiedMemoFwdDate;
    }

    public String getEnquiryDetails() {
        return this.enquiryDetails;
    }

    public void setEnquiryDetails(String enquiryDetails) {
        this.enquiryDetails = enquiryDetails;
    }

    public Date getEnquiryDate() {
        return this.enquiryDate;
    }

    public void setEnquiryDate(Date enquiryDate) {
        this.enquiryDate = enquiryDate;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.legalCase != null && !DateUtils.compareDates((Date)this.getOrderDate(), (Date)this.legalCase.getCaseDate())) {
            errors.add(new ValidationError("orderDate", "orderdate.less.casedate"));
        }
        if (!DateUtils.compareDates((Date)this.getImplementByDate(), (Date)this.getOrderDate())) {
            errors.add(new ValidationError("implementByDate", "implementByDate.less.orderDate"));
        }
        if (!DateUtils.compareDates((Date)this.getSentToDeptOn(), (Date)this.getOrderDate())) {
            errors.add(new ValidationError("sentToDeptOn", "sentToDeptOn.less.orderDate"));
        }
        if (!DateUtils.compareDates((Date)this.getEnquiryDate(), (Date)this.getOrderDate())) {
            errors.add(new ValidationError("enquirydate", "enquirydate.less.orderDate"));
        }
        if (!DateUtils.compareDates((Date)this.getSapHearingDate(), (Date)this.getOrderDate())) {
            errors.add(new ValidationError("sapHearingDate", "sapHearingDate.less.orderDate"));
        }
        if (!DateUtils.compareDates((Date)this.getSetasidePetitionDate(), (Date)this.getOrderDate())) {
            errors.add(new ValidationError("setasidePetitionDate", "setasidePetitionDate.less.orderDate"));
        }
        Iterator<JudgmentImpl> iterator = this.getJudgmentImpl().iterator();
        while (iterator.hasNext()) {
            JudgmentImpl judgmentimpl;
            JudgmentImpl element = judgmentimpl = iterator.next();
            errors.addAll(element.validate());
        }
        return errors;
    }
}

