/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.masters.entity.GovernmentDepartment;
import org.egov.lcms.transactions.entity.LegalCase;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_BIPARTISANDETAILS")
@SequenceGenerator(name="SEQ_EGLC_BIPARTISANDETAILS", sequenceName="SEQ_EGLC_BIPARTISANDETAILS", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class BipartisanDetails
extends AbstractAuditable {
    public static final String SEQ_EGLC_BIPARTISANDETAILS = "SEQ_EGLC_BIPARTISANDETAILS";
    @Expose
    @Id
    @GeneratedValue(generator="SEQ_EGLC_BIPARTISANDETAILS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull
    @JoinColumn(name="legalcase")
    @Audited
    private LegalCase legalCase;
    @NotNull
    @Length(max=128)
    @Audited
    private String name;
    @Length(max=256)
    @Audited
    private String address;
    @Pattern(regexp="[0-9-,()OR]+")
    @Audited
    private String contactNumber;
    @Column(name="isrespondent")
    @Audited
    private Boolean isRepondent = false;
    @ManyToOne
    @Valid
    @JoinColumn(name="respondentgovtdept")
    @Audited
    private GovernmentDepartment governmentDepartment;
    @Column(name="isrespondentgovernment", nullable=false)
    @Audited
    private Boolean isRespondentGovernment = false;
    @Column(name="serialnumber")
    @Audited
    private Long serialNumber;

    public GovernmentDepartment getGovernmentDepartment() {
        return this.governmentDepartment;
    }

    public void setGovernmentDepartment(GovernmentDepartment governmentDepartment) {
        this.governmentDepartment = governmentDepartment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContactNumber() {
        return this.contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getIsRespondentGovernment().booleanValue() && this.getGovernmentDepartment() == null) {
            if (this.getIsRepondent().booleanValue()) {
                errors.add(new ValidationError("govtDept", "respondent.govtDept.select"));
            } else {
                errors.add(new ValidationError("govtDept", "petitioner.govtDept.select"));
            }
        }
        if (!this.getIsRespondentGovernment().booleanValue()) {
            if (this.getIsRepondent().booleanValue() && StringUtils.isBlank((String)this.getName())) {
                errors.add(new ValidationError("respondent", "respondentName.null"));
            }
            if (!this.getIsRepondent().booleanValue() && StringUtils.isBlank((String)this.getName())) {
                errors.add(new ValidationError("petitioner", "petitionerName.null"));
            }
        }
        return errors;
    }

    public Long getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(Long serialNumber) {
        this.serialNumber = serialNumber;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }

    public Boolean getIsRepondent() {
        return this.isRepondent;
    }

    public void setIsRepondent(Boolean isRepondent) {
        this.isRepondent = isRepondent;
    }

    public Boolean getIsRespondentGovernment() {
        return this.isRespondentGovernment;
    }

    public void setIsRespondentGovernment(Boolean isRespondentGovernment) {
        this.isRespondentGovernment = isRespondentGovernment;
    }
}

