/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.entity.es;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="hearingsdocument", type="hearingsdocument")
public class HearingsDocument {
    @Id
    private String id;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date hearingDate;
    @Field(type=FieldType.String)
    private String purposeOfHearing;
    @Field(type=FieldType.String)
    private String hearingOutcome;
    @Field(type=FieldType.Boolean)
    private boolean standingCounselPresent;
    @Field(type=FieldType.String)
    private String additionalLawyer;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String employeeNames;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String lcNumber;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date createdDate;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String cityName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String cityCode;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String cityGrade;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String districtName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String regionName;

    public String getCityGrade() {
        return this.cityGrade;
    }

    public void setCityGrade(String cityGrade) {
        this.cityGrade = cityGrade;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLcNumber() {
        return this.lcNumber;
    }

    public void setLcNumber(String lcNumber) {
        this.lcNumber = lcNumber;
    }

    public Date getHearingDate() {
        return this.hearingDate;
    }

    public void setHearingDate(Date hearingDate) {
        this.hearingDate = hearingDate;
    }

    public String getPurposeOfHearing() {
        return this.purposeOfHearing;
    }

    public void setPurposeOfHearing(String purposeOfHearing) {
        this.purposeOfHearing = purposeOfHearing;
    }

    public String getHearingOutcome() {
        return this.hearingOutcome;
    }

    public void setHearingOutcome(String hearingOutcome) {
        this.hearingOutcome = hearingOutcome;
    }

    public String getAdditionalLawyer() {
        return this.additionalLawyer;
    }

    public void setAdditionalLawyer(String additionalLawyer) {
        this.additionalLawyer = additionalLawyer;
    }

    public String getEmployeeNames() {
        return this.employeeNames;
    }

    public void setEmployeeNames(String employeeNames) {
        this.employeeNames = employeeNames;
    }

    public Boolean getStandingCounselPresent() {
        return this.standingCounselPresent;
    }

    public void setStandingCounselPresent(Boolean standingCounselPresent) {
        this.standingCounselPresent = standingCounselPresent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String lcNumber;
        private Date hearingDate;
        private String purposeOfHearing;
        private String hearingOutcome;
        private String additionalLawyer;
        private String employeeNames;
        private Boolean standingCounselPresent;
        private String cityName;
        private String cityCode;
        private String id;
        private Date createdDate;
        private String cityGrade;
        private String regionName;
        private String districtName;

        private Builder() {
        }

        public Builder withLcNumber(String lcNumber) {
            this.lcNumber = lcNumber;
            return this;
        }

        public Builder withHearingDate(Date hearingDate) {
            this.hearingDate = hearingDate;
            return this;
        }

        public Builder withHearingOutcome(String hearingOutcome) {
            this.hearingOutcome = hearingOutcome;
            return this;
        }

        public Builder withPurposeOfHearing(String purposeOfHearing) {
            this.purposeOfHearing = purposeOfHearing;
            return this;
        }

        public Builder withEmployeeNames(String employeeNames) {
            this.employeeNames = employeeNames;
            return this;
        }

        public Builder withAdditionalLawyer(String additionalLawyer) {
            this.additionalLawyer = additionalLawyer;
            return this;
        }

        public Builder withStandingCounselPresent(Boolean standingCounselPresent) {
            this.standingCounselPresent = standingCounselPresent;
            return this;
        }

        public Builder withCreatedDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder withCityCode(String citycode) {
            this.cityCode = citycode;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withCityGrade(String cityGrade) {
            this.cityGrade = cityGrade;
            return this;
        }

        public Builder withRegionName(String regionname) {
            this.regionName = regionname;
            return this;
        }

        public Builder withDistrictName(String districtname) {
            this.districtName = districtname;
            return this;
        }

        public Builder withCityName(String cityname) {
            this.cityName = cityname;
            return this;
        }

        public HearingsDocument build() {
            HearingsDocument hearingsIndex = new HearingsDocument();
            hearingsIndex.setLcNumber(this.lcNumber);
            hearingsIndex.setHearingDate(this.hearingDate);
            hearingsIndex.setId(this.id);
            hearingsIndex.setHearingOutcome(this.hearingOutcome);
            hearingsIndex.setPurposeOfHearing(this.purposeOfHearing);
            hearingsIndex.setStandingCounselPresent(this.standingCounselPresent);
            hearingsIndex.setEmployeeNames(this.employeeNames);
            hearingsIndex.setAdditionalLawyer(this.additionalLawyer);
            hearingsIndex.setCityCode(this.cityCode);
            hearingsIndex.setCityName(this.cityName);
            hearingsIndex.setCreatedDate(this.createdDate);
            hearingsIndex.setCityGrade(this.cityGrade);
            hearingsIndex.setDistrictName(this.districtName);
            hearingsIndex.setRegionName(this.regionName);
            return hearingsIndex;
        }
    }
}

