/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgwStatus;
import org.egov.eis.entity.Employee;
import org.egov.infra.utils.DateUtils;
import org.egov.lcms.transactions.entity.EmployeeHearing;
import org.egov.lcms.transactions.entity.Hearings;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.ReportStatus;
import org.egov.lcms.transactions.repository.HearingsRepository;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.egov.lcms.transactions.service.LegalCaseSmsService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;

@Service
@Transactional(readOnly=true)
public class HearingsService {
    @Autowired
    private HearingsRepository hearingsRepository;
    @PersistenceContext
    public EntityManager entityManager;
    @Autowired
    private LegalCaseUtil legalCaseUtil;
    @Autowired
    private LegalCaseSmsService legalCaseSmsService;
    @Autowired
    private LegalCaseService legalCaseService;

    @Transactional
    public Hearings persist(Hearings hearings) throws ParseException {
        this.buildEmplyeeList(hearings);
        this.updateNextDate(hearings, hearings.getLegalCase());
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "HEARING");
        hearings.getLegalCase().setStatus(statusObj);
        ReportStatus reportStatus = null;
        hearings.getLegalCase().setReportStatus(reportStatus);
        this.legalCaseSmsService.sendSmsToOfficerInchargeForHearings(hearings);
        this.legalCaseSmsService.sendSmsToHearingEmployee(hearings);
        this.legalCaseSmsService.sendSmsToStandingCounselForHearings(hearings);
        this.legalCaseService.persistLegalCaseIndex(hearings.getLegalCase(), null, null, null, null);
        return (Hearings)((Object)this.hearingsRepository.save((Object)hearings));
    }

    @Transactional
    public Hearings buildEmplyeeList(Hearings hearings) {
        for (EmployeeHearing hearingEmp : hearings.getPositionTemplList()) {
            String empUserName;
            if (hearingEmp.getEmpPosName() != null) {
                empUserName = hearingEmp.getEmpPosName().split("@")[1];
                this.prepareEmployeeHearingList(hearings, empUserName, hearingEmp);
            }
            if (hearingEmp.getId() != null || hearingEmp.getEmployee() == null || hearingEmp.getEmployee().getName() == null || !hearingEmp.getEmployee().getName().contains("@")) continue;
            empUserName = hearingEmp.getEmployee().getName().split("@")[1];
            this.prepareEmployeeHearingList(hearings, empUserName, hearingEmp);
        }
        if (hearings.getPositionTemplList().size() > 0 && hearings.getPositionTemplList().size() < hearings.getEmployeeHearingList().size()) {
            hearings.getEmployeeHearingList().clear();
            for (EmployeeHearing hearingEmp : hearings.getPositionTemplList()) {
                hearingEmp.setHearing(hearings);
                hearings.getEmployeeHearingList().add(hearingEmp);
            }
        }
        return hearings;
    }

    private void prepareEmployeeHearingList(Hearings hearings, String empUserName, EmployeeHearing hearingEmp) {
        Employee employeeObj = this.legalCaseUtil.getEmployeeByUserName(empUserName);
        hearingEmp.setHearing(hearings);
        hearingEmp.setEmployee(employeeObj);
        hearings.getEmployeeHearingList().add(hearingEmp);
    }

    public List<Hearings> findAll() {
        return this.hearingsRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{""}));
    }

    public Hearings findById(Long id) {
        return (Hearings)((Object)this.hearingsRepository.findOne(id));
    }

    public List<Hearings> findByLCNumber(String lcNumber) {
        return this.hearingsRepository.findByLegalCase_lcNumber(lcNumber);
    }

    public void updateNextDate(Hearings hearings, LegalCase legalCase) {
        if (!DateUtils.compareDates((Date)legalCase.getNextDate(), (Date)hearings.getHearingDate())) {
            legalCase.setNextDate(hearings.getHearingDate());
        } else {
            ArrayList<Date> hearingDateList = new ArrayList<Date>(0);
            hearingDateList.add(hearings.getHearingDate());
            for (Hearings hearingsObj : legalCase.getHearings()) {
                if (hearingsObj.getId().equals(hearings.getId())) continue;
                hearingDateList.add(hearingsObj.getHearingDate());
            }
            legalCase.setNextDate((Date)Collections.max(hearingDateList));
        }
    }

    public BindingResult validateDate(Hearings hearings, LegalCase legalCase, BindingResult errors) {
        if (!DateUtils.compareDates((Date)hearings.getHearingDate(), (Date)hearings.getLegalCase().getCaseDate())) {
            errors.rejectValue("hearingDate", "validatedate.hearing.casedate");
        }
        List<Hearings> hearingsList = legalCase.getHearings();
        int count = 0;
        for (Hearings hearings2 : hearingsList) {
            if (!DateUtils.compareDates((Date)hearings2.getHearingDate(), (Date)new Date())) continue;
            ++count;
        }
        if (count >= 1) {
            errors.rejectValue("hearingDate", "validatedate.hearing.futuredate");
        }
        return errors;
    }
}

