/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.lcms.reports.entity.DueReportResult;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DueLegalCaseReportService {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<DueReportResult> getLegalCaseReport(DueReportResult dueReportResult, String reportType) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select  legalObj  as  legalCase ,courtmaster.name  as  courtName ,");
        queryStr.append(" legalObj.status.code  as  caseStatus,position.name as officerInChargeName ");
        if (reportType.equals("Employee Hearings")) {
            queryStr.append(" ,empHearing.hearingDate  as  hearingDate ");
        }
        if (reportType.equals("Judgement Implementation")) {
            queryStr.append(" ,judgementImpl.dateOfCompliance as judgementImplDate ");
        }
        queryStr.append(" from LegalCase legalObj left join legalObj.officerIncharge position,CourtMaster courtmaster,CaseTypeMaster casetypemaster,");
        queryStr.append(" PetitionTypeMaster petmaster");
        if (reportType.equals("Employee Hearings") || reportType.equals("Judgement Implementation")) {
            queryStr.append(" ,EgwStatus egwStatus ");
        }
        if (reportType.equals("Employee Hearings")) {
            queryStr.append(" ,Hearings empHearing ");
        }
        if (reportType.equals("Judgement Implementation")) {
            queryStr.append(" ,Judgment judgement,JudgmentImpl judgementImpl ");
        }
        if (reportType.equals("CA Due date") || reportType.equals("PWR due date")) {
            queryStr.append(" ,Pwr egPwr ");
        }
        queryStr.append(" where legalObj.courtMaster.id=courtmaster.id and ");
        queryStr.append(" legalObj.caseTypeMaster.id=casetypemaster.id and legalObj.petitionTypeMaster.id=petmaster.id  ");
        if (reportType.equals("CA Due date") || reportType.equals("PWR due date")) {
            queryStr.append("  and egPwr.legalCase.id=legalObj.id ");
        }
        if (reportType.equals("PWR due date")) {
            queryStr.append(" and egPwr.pwrDueDate is null ");
        }
        if (reportType.equals("CA Due date")) {
            queryStr.append(" and egPwr.caDueDate is NOT NULL ");
        }
        if (reportType.equals("Employee Hearings") || reportType.equals("Judgement Implementation")) {
            queryStr.append(" and legalObj.status.id=egwStatus.id and egwStatus.moduletype =:moduleType ");
            queryStr.append(" and egwStatus.code in (:statusCodeList ) ");
        }
        if (reportType.equals("Employee Hearings")) {
            queryStr.append(" and empHearing.legalCase.id=legalObj.id  ");
            if (dueReportResult.getCaseFromDate() != null) {
                queryStr.append(" and empHearing.hearingDate >=:fromdate ");
            }
            if (dueReportResult.getCaseToDate() != null) {
                queryStr.append(" and empHearing.hearingDate <=:toDate ");
            }
        }
        if (reportType.equals("Judgement Implementation")) {
            queryStr.append(" and judgement.legalCase.id=legalObj.id  ");
            queryStr.append(" and judgement.id=judgementImpl.judgment.id  ");
            if (dueReportResult.getCaseFromDate() != null) {
                queryStr.append(" and judgementImpl.dateOfCompliance >=:fromdate ");
            }
            if (dueReportResult.getCaseToDate() != null) {
                queryStr.append(" and judgementImpl.dateOfCompliance <=:toDate ");
            }
        }
        if (dueReportResult.getOfficerIncharge() != null) {
            queryStr.append(" and position.id =:officerIncharge ");
        }
        if (!reportType.equals("Employee Hearings") && !reportType.equals("Judgement Implementation")) {
            this.getAppendQuery(dueReportResult, queryStr);
        }
        Query queryResult = this.getCurrentSession().createQuery(queryStr.toString());
        queryResult = this.setParametersToQuery(dueReportResult, queryResult, reportType);
        List legalcaseSearchList = queryResult.list();
        return legalcaseSearchList;
    }

    private Query setParametersToQuery(DueReportResult dueReportResult, Query queryResult, String reportType) {
        ArrayList<String> statusCodeList = new ArrayList<String>();
        if (reportType.equals("Employee Hearings") || reportType.equals("Judgement Implementation")) {
            queryResult.setString("moduleType", "Legal Case");
        }
        if (reportType.equals("Employee Hearings")) {
            statusCodeList.add("LCCREATED");
            statusCodeList.add("HEARING");
            statusCodeList.add("INTERIM_STAY");
            queryResult.setParameterList("statusCodeList", statusCodeList);
        }
        if (reportType.equals("Judgement Implementation")) {
            statusCodeList.add("JUDGEMENT_IMPL");
            queryResult.setParameterList("statusCodeList", statusCodeList);
        }
        if (dueReportResult.getOfficerIncharge() != null) {
            queryResult.setLong("officerIncharge", dueReportResult.getOfficerIncharge().longValue());
        }
        if (dueReportResult.getCaseFromDate() != null) {
            queryResult.setDate("fromdate", dueReportResult.getCaseFromDate());
        }
        if (dueReportResult.getCaseToDate() != null) {
            queryResult.setDate("toDate", dueReportResult.getCaseToDate());
        }
        queryResult.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DueReportResult.class));
        return queryResult;
    }

    private void getAppendQuery(DueReportResult dueReportResult, StringBuilder queryStr) {
        if (dueReportResult.getCaseFromDate() != null) {
            queryStr.append(" and legalObj.caseDate >=:fromdate ");
        }
        if (dueReportResult.getCaseToDate() != null) {
            queryStr.append(" and legalObj.caseDate <=:toDate ");
        }
    }
}

