/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.transactions.entity.LegalCase;
import org.springframework.data.jpa.domain.AbstractPersistable;

@Entity
@Table(name="EGLC_LEGALCASE_BATCHCASE")
@SequenceGenerator(name="SEQ_EGLC_LEGALCASE_BATCHCASE", sequenceName="SEQ_EGLC_LEGALCASE_BATCHCASE", allocationSize=1)
public class BatchCase
extends AbstractPersistable<Long> {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_LEGALCASE_BATCHCASE = "SEQ_EGLC_LEGALCASE_BATCHCASE";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_LEGALCASE_BATCHCASE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="legalcase", nullable=false)
    private LegalCase legalCase;
    @DateFormat(message="invalid.fieldvalue.model.batchCaseDate")
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="invalid.batchcase.date")
    @Column(name="casedate")
    private Date batchCaseDate;
    @OptionalPattern(regex="[0-9a-zA-Z-&/() .]+", message="batchcase.number.alphanumeric")
    private String casenumber;
    @OptionalPattern(regex="^[a-z|A-Z|]+[a-z|A-Z|0-9|&/() .,]*", message="petitionerName.batchcase.mixedChar")
    @Column(name="petitionername")
    private String petitionerName;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getBatchCaseDate() {
        return this.batchCaseDate;
    }

    public void setBatchCaseDate(Date batchCaseDate) {
        this.batchCaseDate = batchCaseDate;
    }

    public String getPetitionerName() {
        return this.petitionerName;
    }

    public void setPetitionerName(String petitionerName) {
        this.petitionerName = petitionerName;
    }

    public String getCasenumber() {
        return this.casenumber;
    }

    public void setCasenumber(String casenumber) {
        this.casenumber = casenumber;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        return errors;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }
}

