/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.lcms.transactions.entity.Appeal;
import org.hibernate.validator.constraints.Length;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="eglc_appeal_documents")
@SequenceGenerator(name="SEQ_eglc_appeal_document", sequenceName="SEQ_eglc_appeal_document", allocationSize=1)
public class AppealDocuments
extends AbstractPersistable<Long> {
    private static final long serialVersionUID = -4555037259173138199L;
    public static final String SEQ_APPEALDOCUMENTS = "SEQ_eglc_appeal_document";
    @Id
    @GeneratedValue(generator="SEQ_eglc_appeal_document", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="appeal", nullable=false)
    private Appeal appeal;
    @NotNull
    @Length(min=3, max=100)
    private String documentName;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="eglc_appeal_filestore", joinColumns={@JoinColumn(name="appealdocid")}, inverseJoinColumns={@JoinColumn(name="filestoreid")})
    private FileStoreMapper supportDocs;
    private transient MultipartFile[] files;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Appeal getAppeal() {
        return this.appeal;
    }

    public void setAppeal(Appeal appeal) {
        this.appeal = appeal;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public FileStoreMapper getSupportDocs() {
        return this.supportDocs;
    }

    public void setSupportDocs(FileStoreMapper supportDocs) {
        this.supportDocs = supportDocs;
    }

    public MultipartFile[] getFiles() {
        return this.files;
    }

    public void setFiles(MultipartFile[] files) {
        this.files = files;
    }
}

