/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.entity.es;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="legalcasedocument", type="legalcasedocument")
public class LegalCaseDocument {
    @Id
    private String id;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String caseNumber;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String lcNumber;
    @Field(type=FieldType.String)
    private String caseTitle;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String caseType;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String courtName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String courtType;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String petitionType;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String officerIncharge;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date caseDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date caseReceivingDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date nextDate;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String previousCaseNumber;
    @Field(type=FieldType.Boolean)
    private boolean filedByULB;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String status;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String subStatus;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String petitionerNames;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String respondantNames;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date caFilingDate;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String advocateName;
    @Field(type=FieldType.Boolean)
    private boolean seniorAdvocate;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String interimOrderType;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String judgmentOutcome;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date judgmentDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date orderSentToDeptDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date deadLineImplementByDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date judgmentImplDate;
    @Field(type=FieldType.String)
    private String judgmentImplemented;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String implementationFailure;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date disposalDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date createdDate;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String cityName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String cityCode;

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getId() {
        return this.id;
    }

    public void setId() {
        this.id = ApplicationThreadLocals.getCityCode().concat("_").concat(this.lcNumber);
    }

    public String getCaseNumber() {
        return this.caseNumber;
    }

    public void setCaseNumber(String caseNumber) {
        this.caseNumber = caseNumber;
    }

    public String getLcNumber() {
        return this.lcNumber;
    }

    public void setLcNumber(String lcNumber) {
        this.lcNumber = lcNumber;
    }

    public String getCaseType() {
        return this.caseType;
    }

    public void setCaseType(String caseType) {
        this.caseType = caseType;
    }

    public String getCourtName() {
        return this.courtName;
    }

    public void setCourtName(String courtName) {
        this.courtName = courtName;
    }

    public String getCourtType() {
        return this.courtType;
    }

    public void setCourtType(String courtType) {
        this.courtType = courtType;
    }

    public String getPetitionType() {
        return this.petitionType;
    }

    public void setPetitionType(String petitionType) {
        this.petitionType = petitionType;
    }

    public String getCaseTitle() {
        return this.caseTitle;
    }

    public void setCaseTitle(String caseTitle) {
        this.caseTitle = caseTitle;
    }

    public String getOfficerIncharge() {
        return this.officerIncharge;
    }

    public void setOfficerIncharge(String officerIncharge) {
        this.officerIncharge = officerIncharge;
    }

    public Date getCaseDate() {
        return this.caseDate;
    }

    public void setCaseDate(Date caseDate) {
        this.caseDate = caseDate;
    }

    public Date getCaseReceivingDate() {
        return this.caseReceivingDate;
    }

    public void setCaseReceivingDate(Date caseReceivingDate) {
        this.caseReceivingDate = caseReceivingDate;
    }

    public Date getNextDate() {
        return this.nextDate;
    }

    public void setNextDate(Date nextDate) {
        this.nextDate = nextDate;
    }

    public String getPreviousCaseNumber() {
        return this.previousCaseNumber;
    }

    public void setPreviousCaseNumber(String previousCaseNumber) {
        this.previousCaseNumber = previousCaseNumber;
    }

    public Boolean isFiledByULB() {
        return this.filedByULB;
    }

    public void setFiledByULB(Boolean filedByULB) {
        this.filedByULB = filedByULB;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSubStatus() {
        return this.subStatus;
    }

    public void setSubStatus(String subStatus) {
        this.subStatus = subStatus;
    }

    public String getPetitionerNames() {
        return this.petitionerNames;
    }

    public void setPetitionerNames(String petitionerNames) {
        this.petitionerNames = petitionerNames;
    }

    public String getRespondantNames() {
        return this.respondantNames;
    }

    public void setRespondantNames(String respondantNames) {
        this.respondantNames = respondantNames;
    }

    public Date getCaFilingDate() {
        return this.caFilingDate;
    }

    public void setCaFilingDate(Date caFilingDate) {
        this.caFilingDate = caFilingDate;
    }

    public String getAdvocateName() {
        return this.advocateName;
    }

    public void setAdvocateName(String advocateName) {
        this.advocateName = advocateName;
    }

    public Boolean isSeniorAdvocate() {
        return this.seniorAdvocate;
    }

    public void setSeniorAdvocate(Boolean seniorAdvocate) {
        this.seniorAdvocate = seniorAdvocate;
    }

    public String getInterimOrderType() {
        return this.interimOrderType;
    }

    public void setInterimOrderType(String interimOrderType) {
        this.interimOrderType = interimOrderType;
    }

    public String getJudgmentOutcome() {
        return this.judgmentOutcome;
    }

    public void setJudgmentOutcome(String judgmentOutcome) {
        this.judgmentOutcome = judgmentOutcome;
    }

    public Date getJudgmentDate() {
        return this.judgmentDate;
    }

    public void setJudgmentDate(Date judgmentDate) {
        this.judgmentDate = judgmentDate;
    }

    public Date getOrderSentToDeptDate() {
        return this.orderSentToDeptDate;
    }

    public void setOrderSentToDeptDate(Date orderSentToDeptDate) {
        this.orderSentToDeptDate = orderSentToDeptDate;
    }

    public Date getDeadLineImplementByDate() {
        return this.deadLineImplementByDate;
    }

    public void setDeadLineImplementByDate(Date deadLineImplementByDate) {
        this.deadLineImplementByDate = deadLineImplementByDate;
    }

    public Date getJudgmentImplDate() {
        return this.judgmentImplDate;
    }

    public void setJudgmentImplDate(Date judgmentImplDate) {
        this.judgmentImplDate = judgmentImplDate;
    }

    public String getJudgmentImplemented() {
        return this.judgmentImplemented;
    }

    public void setJudgmentImplemented(String judgmentImplemented) {
        this.judgmentImplemented = judgmentImplemented;
    }

    public String getImplementationFailure() {
        return this.implementationFailure;
    }

    public void setImplementationFailure(String implementationFailure) {
        this.implementationFailure = implementationFailure;
    }

    public Date getDisposalDate() {
        return this.disposalDate;
    }

    public void setDisposalDate(Date disposalDate) {
        this.disposalDate = disposalDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String caseNumber;
        private String lcNumber;
        private String caseTitle;
        private String caseType;
        private String courtName;
        private String courtType;
        private String petitionType;
        private Date caseDate;
        private Date caseReceivingDate;
        private String previousCaseNumber;
        private String officerIncharge;
        private Date nextDate;
        private Boolean filedByULB;
        private String status;
        private String subStatus;
        private String petitionerNames;
        private String respondantNames;
        private String cityName;
        private String cityCode;
        private Date createdDate;

        private Builder() {
        }

        public Builder withCaseNumber(String caseNumber) {
            this.caseNumber = caseNumber;
            return this;
        }

        public Builder withLcNumber(String lcNumber) {
            this.lcNumber = lcNumber;
            return this;
        }

        public Builder withCaseTitle(String caseTitle) {
            this.caseTitle = caseTitle;
            return this;
        }

        public Builder withCaseType(String caseType) {
            this.caseType = caseType;
            return this;
        }

        public Builder withCourtName(String courtName) {
            this.courtName = courtName;
            return this;
        }

        public Builder withCourtType(String courtType) {
            this.courtType = courtType;
            return this;
        }

        public Builder withPetitionType(String petitionType) {
            this.petitionType = petitionType;
            return this;
        }

        public Builder withPreviousCaseNumber(String previousCaseNumber) {
            this.previousCaseNumber = previousCaseNumber;
            return this;
        }

        public Builder withCaseDate(Date caseDate) {
            this.caseDate = caseDate;
            return this;
        }

        public Builder withCaseReceivingDate(Date caseReceivingDate) {
            this.caseReceivingDate = caseReceivingDate;
            return this;
        }

        public Builder withOfficerIncharge(String officerIncharge) {
            this.officerIncharge = officerIncharge;
            return this;
        }

        public Builder withNextDate(Date nextDate) {
            this.nextDate = nextDate;
            return this;
        }

        public Builder withFiledByULB(Boolean filedByULB) {
            this.filedByULB = filedByULB;
            return this;
        }

        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withSubStatus(String subStatus) {
            this.subStatus = subStatus;
            return this;
        }

        public Builder withPetitionerNames(String petitionerNames) {
            this.petitionerNames = petitionerNames;
            return this;
        }

        public Builder withRespondantNames(String respondantNames) {
            this.respondantNames = respondantNames;
            return this;
        }

        public Builder withCreatedDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder withCityCode(String citycode) {
            this.cityCode = citycode;
            return this;
        }

        public Builder withCityName(String cityname) {
            this.cityName = cityname;
            return this;
        }

        public LegalCaseDocument build() {
            LegalCaseDocument legalCaseIndex = new LegalCaseDocument();
            legalCaseIndex.setCaseNumber(this.caseNumber);
            legalCaseIndex.setLcNumber(this.lcNumber);
            legalCaseIndex.setId();
            legalCaseIndex.setCaseTitle(this.caseTitle);
            legalCaseIndex.setCaseType(this.caseType);
            legalCaseIndex.setCourtName(this.courtName);
            legalCaseIndex.setCourtType(this.courtType);
            legalCaseIndex.setPetitionType(this.petitionType);
            legalCaseIndex.setPreviousCaseNumber(this.previousCaseNumber);
            legalCaseIndex.setCaseDate(this.caseDate);
            legalCaseIndex.setCaseReceivingDate(this.caseReceivingDate);
            legalCaseIndex.setFiledByULB(this.filedByULB);
            legalCaseIndex.setNextDate(this.nextDate);
            legalCaseIndex.setOfficerIncharge(this.officerIncharge);
            legalCaseIndex.setStatus(this.status);
            legalCaseIndex.setSubStatus(this.subStatus);
            legalCaseIndex.setPetitionerNames(this.petitionerNames);
            legalCaseIndex.setRespondantNames(this.respondantNames);
            legalCaseIndex.setCityCode(this.cityCode);
            legalCaseIndex.setCityName(this.cityName);
            legalCaseIndex.setCreatedDate(this.createdDate);
            return legalCaseIndex;
        }
    }
}

