/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.lcms.entity.es.LegalCaseDocument;
import org.egov.lcms.masters.entity.AdvocateMaster;
import org.egov.lcms.masters.service.AdvocateMasterService;
import org.egov.lcms.service.es.LegalCaseDocumentService;
import org.egov.lcms.transactions.entity.BipartisanDetails;
import org.egov.lcms.transactions.entity.CounterAffidavit;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseAdvocate;
import org.egov.lcms.transactions.entity.LegalCaseDisposal;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.egov.lcms.transactions.entity.LegalCaseUploadDocuments;
import org.egov.lcms.transactions.entity.Pwr;
import org.egov.lcms.transactions.entity.PwrDocuments;
import org.egov.lcms.transactions.entity.ReportStatus;
import org.egov.lcms.transactions.repository.LegalCaseRepository;
import org.egov.lcms.transactions.repository.LegalCaseUploadDocumentsRepository;
import org.egov.lcms.transactions.repository.PwrDocumentsRepository;
import org.egov.lcms.transactions.repository.ReportStatusRepository;
import org.egov.lcms.transactions.service.LegalCaseSmsService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class LegalCaseService {
    private final LegalCaseRepository legalCaseRepository;
    @Autowired
    private PwrDocumentsRepository pwrDocumentsRepository;
    @Autowired
    private AdvocateMasterService advocateMasterService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private LegalCaseSmsService legalCaseSmsService;
    @Autowired
    private LegalCaseUploadDocumentsRepository legalCaseUploadDocumentsRepository;
    @Autowired
    private ReportStatusRepository reportStatusRepository;
    @Autowired
    private LegalCaseDocumentService legalCaseDocumentService;

    @Autowired
    public LegalCaseService(LegalCaseRepository legalCaseRepository) {
        this.legalCaseRepository = legalCaseRepository;
    }

    public LegalCase findById(Long Id2) {
        return (LegalCase)((Object)this.legalCaseRepository.findOne(Id2));
    }

    public LegalCase findByLcNumber(String lcnumber) {
        return this.legalCaseRepository.findByLcNumber(lcnumber);
    }

    public LegalCase getLegalCaseByCaseNumber(String caseNumber) {
        return this.legalCaseRepository.findByCaseNumber(caseNumber);
    }

    @Transactional
    public LegalCase persist(LegalCase legalcase, MultipartFile[] files) throws IOException, ParseException {
        legalcase.setCaseNumber(legalcase.getCaseNumber() + (legalcase.getWpYear() != null ? "/" + legalcase.getWpYear() : ""));
        legalcase.setStatus(this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "LCCREATED"));
        this.prepareChildEntities(legalcase);
        this.updateNextDate(legalcase, legalcase.getPwrList());
        this.setLegalCaseReportStatus(legalcase, legalcase.getPwrList());
        LegalCase savedlegalcase = (LegalCase)((Object)this.legalCaseRepository.save((Object)legalcase));
        this.legalCaseSmsService.sendSmsToOfficerInchargeForLegalCase(legalcase);
        this.persistLegalCaseIndex(savedlegalcase, null, null, null, null);
        List<LegalCaseUploadDocuments> documentDetails = this.getLegalcaseUploadDocumentDetails(savedlegalcase, files);
        if (!documentDetails.isEmpty()) {
            savedlegalcase.setLegalCaseUploadDocuments(documentDetails);
            this.persistLegalcaseUploadDocuments(documentDetails);
        }
        return savedlegalcase;
    }

    @Transactional
    public LegalCase update(LegalCase legalcase, MultipartFile[] files) throws IOException, ParseException {
        this.updateCounterAffidavitAndPwr(legalcase, legalcase.getPwrList());
        LegalCase savedCaAndPwr = (LegalCase)((Object)this.legalCaseRepository.save((Object)legalcase));
        this.persistLegalCaseIndex(legalcase, null, null, null, null);
        this.legalCaseSmsService.sendSmsToOfficerInchargeForCounterAffidavit(legalcase.getCounterAffidavits());
        this.legalCaseSmsService.sendSmsToOfficerInchargeForPWR(legalcase.getPwrList());
        this.legalCaseSmsService.sendSmsToStandingCounselForCounterAffidavit(legalcase.getCounterAffidavits());
        List<PwrDocuments> documentDetails = this.getPwrDocumentDetails(savedCaAndPwr, files);
        if (!documentDetails.isEmpty()) {
            savedCaAndPwr.getPwrList().get(0).setPwrDocuments(documentDetails);
            this.persistPwrDocuments(documentDetails);
        }
        return savedCaAndPwr;
    }

    @Transactional
    public void updateCounterAffidavitAndPwr(LegalCase legalcase, List<Pwr> pwrList) {
        ArrayList<Pwr> pwrListtemp = new ArrayList<Pwr>(0);
        ArrayList<CounterAffidavit> caListtemp = new ArrayList<CounterAffidavit>(0);
        for (Pwr legalpwr : pwrList) {
            legalpwr.setLegalCase(legalcase);
            pwrListtemp.add(legalpwr);
        }
        legalcase.getPwrList().clear();
        legalcase.setPwrList(pwrListtemp);
        for (CounterAffidavit counterAffidavit : legalcase.getCounterAffidavits()) {
            counterAffidavit.setLegalCase(legalcase);
            caListtemp.add(counterAffidavit);
        }
        legalcase.getCounterAffidavits().clear();
        legalcase.setCounterAffidavits(caListtemp);
    }

    public List<LegalCaseUploadDocuments> getLegalCaseDocList(LegalCase legalCase) {
        return legalCase.getLegalCaseUploadDocuments();
    }

    public List<PwrDocuments> getPwrDocList(LegalCase legalCase) {
        return legalCase.getPwrList().get(0).getPwrDocuments();
    }

    public LegalCase prepareChildEntities(LegalCase legalcase) {
        ArrayList<Pwr> pwrListtemp = new ArrayList<Pwr>(0);
        int serialNumberPetitioner = 1;
        int serialNumberRespondent = 1;
        if (legalcase != null) {
            if (legalcase.getBipartisanPetitionerDetailsList() != null || legalcase.getBipartisanRespondentDetailsList() != null) {
                legalcase.getBipartisanDetails().clear();
                this.legalCaseRepository.flush();
            }
            for (BipartisanDetails petitioner : legalcase.getBipartisanPetitionerDetailsList()) {
                if (petitioner.getName() != null && !petitioner.getName().trim().isEmpty()) {
                    petitioner.setSerialNumber(petitioner.getSerialNumber() != null ? petitioner.getSerialNumber() : (long)serialNumberPetitioner);
                    petitioner.setIsRepondent(Boolean.FALSE);
                    if (petitioner.getIsRespondentGovernment() == null) {
                        petitioner.setIsRespondentGovernment(Boolean.FALSE);
                    }
                    petitioner.setLegalCase(legalcase);
                    legalcase.getBipartisanDetails().add(petitioner);
                }
                ++serialNumberPetitioner;
            }
            for (BipartisanDetails respondent : legalcase.getBipartisanRespondentDetailsList()) {
                if (respondent.getName() != null && !respondent.getName().trim().isEmpty()) {
                    respondent.setSerialNumber(respondent.getSerialNumber() != null ? respondent.getSerialNumber() : (long)serialNumberRespondent);
                    respondent.setLegalCase(legalcase);
                    if (respondent.getIsRespondentGovernment() == null) {
                        respondent.setIsRespondentGovernment(Boolean.FALSE);
                    }
                    respondent.setIsRepondent(Boolean.TRUE);
                    legalcase.getBipartisanDetails().add(respondent);
                }
                ++serialNumberRespondent;
            }
        }
        if (!legalcase.getPwrList().isEmpty()) {
            for (Pwr legalpwr : legalcase.getPwrList()) {
                legalpwr.setLegalCase(legalcase);
                pwrListtemp.add(legalpwr);
            }
            legalcase.getPwrList().clear();
            legalcase.setPwrList(pwrListtemp);
        }
        return legalcase;
    }

    @Transactional
    public LegalCase saveStandingCouncilEntity(LegalCaseAdvocate legalCaseAdvocate) throws ParseException {
        LegalCaseAdvocate legalCaseAdvocatetemp = null;
        AdvocateMaster seniorLegalMaster = null;
        AdvocateMaster advocateName = this.advocateMasterService.findByName(legalCaseAdvocate.getAdvocateMaster().getName());
        if (legalCaseAdvocate.getSeniorAdvocate().getName() != null) {
            seniorLegalMaster = this.advocateMasterService.findByName(legalCaseAdvocate.getSeniorAdvocate().getName());
        }
        if (!legalCaseAdvocate.getLegalCase().getLegalCaseAdvocates().isEmpty()) {
            legalCaseAdvocatetemp = legalCaseAdvocate.getLegalCase().getLegalCaseAdvocates().get(0);
            legalCaseAdvocatetemp.setAdvocateMaster(advocateName);
            legalCaseAdvocatetemp.setAssignedToDate(legalCaseAdvocate.getAssignedToDate());
            legalCaseAdvocatetemp.setVakalatDate(legalCaseAdvocate.getVakalatDate());
            legalCaseAdvocatetemp.getLegalCase().setIsSenioradvrequired(legalCaseAdvocate.getIsSeniorAdvocate());
            legalCaseAdvocatetemp.setIsActive(Boolean.TRUE);
            legalCaseAdvocatetemp.setChangeAdvocate(legalCaseAdvocate.getChangeAdvocate());
            legalCaseAdvocatetemp.setChangeSeniorAdvocate(legalCaseAdvocate.getChangeSeniorAdvocate());
            legalCaseAdvocatetemp.setSeniorAdvocate(seniorLegalMaster);
            legalCaseAdvocatetemp.setAssignedToDateForSenior(legalCaseAdvocate.getAssignedToDateForSenior());
            legalCaseAdvocatetemp.setOrderDate(legalCaseAdvocate.getOrderDate());
            legalCaseAdvocatetemp.setOrderNumber(legalCaseAdvocate.getOrderNumber());
            legalCaseAdvocatetemp.setOrderDateJunior(legalCaseAdvocate.getOrderDateJunior());
            legalCaseAdvocatetemp.setOrderNumberJunior(legalCaseAdvocate.getOrderNumberJunior());
            legalCaseAdvocate.getLegalCase().getLegalCaseAdvocates().add(legalCaseAdvocatetemp);
            this.legalCaseSmsService.sendSmsToStandingCounsel(legalCaseAdvocatetemp);
        } else {
            legalCaseAdvocate.setAdvocateMaster(advocateName);
            legalCaseAdvocate.getLegalCase().setIsSenioradvrequired(legalCaseAdvocate.getIsSeniorAdvocate());
            legalCaseAdvocate.setSeniorAdvocate(seniorLegalMaster);
            legalCaseAdvocate.setIsActive(Boolean.TRUE);
            legalCaseAdvocate.getLegalCase().getLegalCaseAdvocates().add(legalCaseAdvocate);
            this.legalCaseSmsService.sendSmsToStandingCounsel(legalCaseAdvocate);
        }
        this.persistLegalCaseIndex(legalCaseAdvocate.getLegalCase(), null, null, null, null);
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalCaseAdvocate.getLegalCase()));
    }

    @Transactional
    public LegalCase save(LegalCase legalcase) {
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalcase));
    }

    public void updateNextDate(LegalCase legalCase, List<Pwr> pwr) {
        if (pwr.get(0).getCaFilingDate() != null) {
            legalCase.setNextDate(pwr.get(0).getCaFilingDate());
        } else if (pwr.get(0).getCaDueDate() != null) {
            legalCase.setNextDate(pwr.get(0).getCaDueDate());
        } else if (pwr.get(0).getPwrDueDate() != null) {
            legalCase.setNextDate(pwr.get(0).getPwrDueDate());
        } else {
            legalCase.setNextDate(legalCase.getCaseDate());
        }
    }

    public List<PwrDocuments> getPwrDocumentDetails(LegalCase legalCase, MultipartFile[] files) throws IOException {
        ArrayList<PwrDocuments> documentDetailsList = new ArrayList<PwrDocuments>();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isEmpty()) continue;
                PwrDocuments applicationDocument = new PwrDocuments();
                applicationDocument.setPwr(legalCase.getPwrList().get(0));
                applicationDocument.setDocumentName("Pwr");
                applicationDocument.setSupportDocs(this.fileStoreService.store(files[i].getInputStream(), files[i].getOriginalFilename(), files[i].getContentType(), "LCMS"));
                documentDetailsList.add(applicationDocument);
            }
        }
        return documentDetailsList;
    }

    public void persistPwrDocuments(List<PwrDocuments> documentDetailsList) {
        if (documentDetailsList != null && !documentDetailsList.isEmpty()) {
            for (PwrDocuments doc : documentDetailsList) {
                this.pwrDocumentsRepository.save((Object)doc);
            }
        }
    }

    public List<LegalCaseUploadDocuments> getLegalcaseUploadDocumentDetails(LegalCase legalCase, MultipartFile[] files) throws IOException {
        ArrayList<LegalCaseUploadDocuments> documentDetailsList = new ArrayList<LegalCaseUploadDocuments>();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isEmpty()) continue;
                LegalCaseUploadDocuments applicationDocument = new LegalCaseUploadDocuments();
                applicationDocument.setLegalCase(legalCase);
                applicationDocument.setDocumentName("LegalCase");
                applicationDocument.setSupportDocs(this.fileStoreService.store(files[i].getInputStream(), files[i].getOriginalFilename(), files[i].getContentType(), "LCMS"));
                documentDetailsList.add(applicationDocument);
            }
        }
        return documentDetailsList;
    }

    public void persistLegalcaseUploadDocuments(List<LegalCaseUploadDocuments> documentDetailsList) {
        if (documentDetailsList != null && !documentDetailsList.isEmpty()) {
            for (LegalCaseUploadDocuments doc : documentDetailsList) {
                this.legalCaseUploadDocumentsRepository.save((Object)doc);
            }
        }
    }

    public void setLegalCaseReportStatus(LegalCase legalCase, List<Pwr> pwr) {
        String caseStatus = legalCase.getStatus().getCode();
        ReportStatus reportStatus = null;
        if (caseStatus.equalsIgnoreCase("LCCREATED") && reportStatus == null && pwr != null && !pwr.isEmpty()) {
            if (pwr.get(0).getCaFilingDate() != null) {
                reportStatus = this.getReportStatusByCode("COUNTER_FILED");
            } else if (pwr.get(0).getPwrApprovalDate() == null) {
                legalCase.setReportStatus(this.getReportStatusByCode("PWR_PENDING"));
            } else {
                reportStatus = this.getReportStatusByCode("DCA_PENDING");
            }
        }
        if (reportStatus != null) {
            legalCase.setReportStatus(reportStatus);
        }
    }

    public ReportStatus getReportStatusByCode(String reportStatusCode) {
        ReportStatus reportStatus = this.reportStatusRepository.findByCode(reportStatusCode);
        return reportStatus;
    }

    public LegalCaseDocument persistLegalCaseIndex(LegalCase legalCase, LegalCaseInterimOrder legalCaseInterimOrder, Judgment judgment, JudgmentImpl judgmentImpl, LegalCaseDisposal closeCase) throws ParseException {
        return this.legalCaseDocumentService.persistLegalCaseDocumentIndex(legalCase, legalCaseInterimOrder, judgment, judgmentImpl, closeCase);
    }
}

