/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.lcms.masters.entity.enums.ImplementationFailure;
import org.egov.lcms.transactions.entity.Appeal;
import org.egov.lcms.transactions.entity.AppealDocuments;
import org.egov.lcms.transactions.entity.Contempt;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.egov.lcms.transactions.entity.ReportStatus;
import org.egov.lcms.transactions.repository.AppealDocumentsRepository;
import org.egov.lcms.transactions.repository.JudgmentImplRepository;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.egov.lcms.transactions.service.LegalCaseSmsService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class JudgmentImplService {
    private final JudgmentImplRepository judgmentImplRepository;
    @Autowired
    private AppealDocumentsRepository appealDocumentsRepository;
    @Autowired
    private LegalCaseService legalCaseService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private LegalCaseSmsService legalCaseSmsService;

    @Autowired
    public JudgmentImplService(JudgmentImplRepository judgmentImplRepository) {
        this.judgmentImplRepository = judgmentImplRepository;
    }

    @Transactional
    public JudgmentImpl persist(JudgmentImpl judgmentImpl, MultipartFile[] files) throws IOException {
        List<AppealDocuments> documentDetails;
        this.persistAppealOrContempt(judgmentImpl);
        JudgmentImpl savedjudgmentImpl = (JudgmentImpl)((Object)this.judgmentImplRepository.save((Object)judgmentImpl));
        if (judgmentImpl.getImplementationFailure() != null && judgmentImpl.getImplementationFailure().toString().equals(ImplementationFailure.Appeal.toString()) && !(documentDetails = this.getDocumentDetails(savedjudgmentImpl, files)).isEmpty()) {
            savedjudgmentImpl.getAppeal().get(0).setAppealDocuments(documentDetails);
            this.persistDocuments(documentDetails);
        }
        return savedjudgmentImpl;
    }

    @Transactional
    public void saveOrUpdate(JudgmentImpl judgmentImpl, MultipartFile[] files) throws IOException, ParseException {
        this.persist(judgmentImpl, files);
        if (judgmentImpl.getJudgment().getImplementByDate() != null) {
            judgmentImpl.getJudgment().getLegalCase().setNextDate(judgmentImpl.getJudgment().getImplementByDate());
        } else {
            judgmentImpl.getJudgment().getLegalCase().setNextDate(judgmentImpl.getJudgment().getOrderDate());
        }
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "JUDGEMENT_IMPL");
        judgmentImpl.getJudgment().getLegalCase().setStatus(statusObj);
        ReportStatus reportStatus = null;
        judgmentImpl.getJudgment().getLegalCase().setReportStatus(reportStatus);
        judgmentImpl.getJudgment().getLegalCase().setNextDate(judgmentImpl.getDateOfCompliance());
        this.legalCaseSmsService.sendSmsToOfficerInchargeForJudgmentImpl(judgmentImpl);
        this.legalCaseSmsService.sendSmsToStandingCounselForJudgmentImpl(judgmentImpl);
        this.legalCaseService.persistLegalCaseIndex(judgmentImpl.getJudgment().getLegalCase(), null, judgmentImpl.getJudgment(), judgmentImpl, null);
        this.legalCaseService.save(judgmentImpl.getJudgment().getLegalCase());
    }

    @Transactional
    public void persistAppealOrContempt(JudgmentImpl judgmentImpl) {
        if (judgmentImpl.getContempt().get(0).getCaNumber() != null) {
            for (Contempt contemptObj : judgmentImpl.getContempt()) {
                contemptObj.setJudgmentImpl(judgmentImpl);
            }
            judgmentImpl.getJudgment().getLegalCase().setNextDate(judgmentImpl.getContempt().get(0).getReceivingDate());
            judgmentImpl.getAppeal().clear();
        } else if (judgmentImpl.getAppeal().get(0).getSrNumber() != null) {
            for (Appeal appealObj : judgmentImpl.getAppeal()) {
                if (appealObj.getSrNumber() == null || "".equals(appealObj.getSrNumber())) continue;
                appealObj.setJudgmentImpl(judgmentImpl);
            }
            judgmentImpl.getJudgment().getLegalCase().setNextDate(judgmentImpl.getAppeal().get(0).getAppealFiledOn());
            judgmentImpl.getContempt().clear();
        } else {
            judgmentImpl.getAppeal().clear();
            judgmentImpl.getContempt().clear();
        }
    }

    public List<AppealDocuments> getAppealDocList(JudgmentImpl judgmentImpl) {
        ArrayList<AppealDocuments> judgmentImplAppealDOc = new ArrayList<AppealDocuments>();
        HashSet<AppealDocuments> appealDOcSet = new HashSet<AppealDocuments>();
        if (!judgmentImpl.getAppeal().isEmpty() && judgmentImpl.getAppeal().get(0) != null) {
            for (AppealDocuments appealDocs : judgmentImpl.getAppeal().get(0).getAppealDocuments()) {
                appealDOcSet.add(appealDocs);
            }
            judgmentImplAppealDOc.addAll(appealDOcSet);
        }
        return judgmentImplAppealDOc;
    }

    public List<AppealDocuments> getDocumentDetails(JudgmentImpl judgmentImpl, MultipartFile[] files) throws IOException {
        ArrayList<AppealDocuments> documentDetailsList = new ArrayList<AppealDocuments>();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isEmpty()) continue;
                AppealDocuments applicationDocument = new AppealDocuments();
                applicationDocument.setAppeal(judgmentImpl.getAppeal().get(0));
                applicationDocument.setDocumentName("Appeal");
                applicationDocument.setSupportDocs(this.fileStoreService.store(files[i].getInputStream(), files[i].getOriginalFilename(), files[i].getContentType(), "LCMS"));
                documentDetailsList.add(applicationDocument);
            }
        }
        return documentDetailsList;
    }

    public void persistDocuments(List<AppealDocuments> documentDetailsList) {
        if (documentDetailsList != null && !documentDetailsList.isEmpty()) {
            for (AppealDocuments doc : documentDetailsList) {
                this.appealDocumentsRepository.save((Object)doc);
            }
        }
    }

    public List<JudgmentImpl> findAll() {
        return this.judgmentImplRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{" "}));
    }

    public JudgmentImpl findOne(Long id) {
        return (JudgmentImpl)((Object)this.judgmentImplRepository.findOne(id));
    }
}

