/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.lcms.reports.entity.LegalCommonReportResult;
import org.egov.lcms.transactions.service.LegalCommonReportService;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.stereotype.Service;

@Service
public class GenericSubReportService {
    private static final String AGGREGATION_BY_FIELD = "aggregationField";
    private static final String COURTNAME = "courtName";
    private static final String PETITIONTYPE = "petitionType";
    private static final String CASETYPE = "caseType";
    private static final String COURTTYPE = "courtType";
    private static final String CASESTATUS = "status";
    private static final String OFFICERINCHRGE = "officerIncharge";
    private static final String JUDGEMENTOUTCOME = "judgmentOutcome";
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private LegalCommonReportService legalCommonReportService;

    public List<LegalCommonReportResult> getGenericSubReports(LegalCommonReportResult genericSubReport) throws ParseException {
        List<Object> finalResult = new ArrayList();
        finalResult = genericSubReport.getAggregatedBy() != null ? this.getGenericReportwithAggregatedValues(genericSubReport) : this.legalCommonReportService.getLegalCommonReportsResults(genericSubReport, "");
        return finalResult;
    }

    private List<LegalCommonReportResult> getGenericReportwithAggregatedValues(LegalCommonReportResult genericSubReport) {
        String aggregationField = this.getaggregationFiledByType(genericSubReport);
        SearchResponse timeSeriesReport = this.findAllLegalcaseIndexByFilter(genericSubReport, this.getFilterQuery(genericSubReport), aggregationField);
        ArrayList<LegalCommonReportResult> responseDetailsList = new ArrayList<LegalCommonReportResult>();
        Terms terms = (Terms)timeSeriesReport.getAggregations().get(AGGREGATION_BY_FIELD);
        for (Terms.Bucket bucket : terms.getBuckets()) {
            ValueCount valueCount = (ValueCount)bucket.getAggregations().get("total_count");
            if (valueCount.getValue() <= 0L) continue;
            LegalCommonReportResult responseDetail = new LegalCommonReportResult();
            responseDetail.setAggregatedBy(bucket.getKeyAsString());
            responseDetail.setCount(valueCount.getValue());
            responseDetailsList.add(responseDetail);
        }
        return responseDetailsList;
    }

    public SearchResponse findAllLegalcaseIndexByFilter(LegalCommonReportResult genericSubReport, BoolQueryBuilder query, String aggregationField) {
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"legalcasedocument"}).setQuery((QueryBuilder)query).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGGREGATION_BY_FIELD).field(aggregationField)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)"total_count").field("lcNumber"))).execute().actionGet();
    }

    private String getaggregationFiledByType(LegalCommonReportResult genericSubReport) {
        String aggregationField = "";
        if (StringUtils.isNotBlank((CharSequence)genericSubReport.getAggregatedBy())) {
            if (genericSubReport.getAggregatedBy().equals("Court Name")) {
                aggregationField = COURTNAME;
            } else if (genericSubReport.getAggregatedBy().equals("Petition Type")) {
                aggregationField = PETITIONTYPE;
            } else if (genericSubReport.getAggregatedBy().equals("Case Category")) {
                aggregationField = CASETYPE;
            } else if (genericSubReport.getAggregatedBy().equals("Case Status")) {
                aggregationField = CASESTATUS;
            } else if (genericSubReport.getAggregatedBy().equals("Court Type")) {
                aggregationField = COURTTYPE;
            } else if (genericSubReport.getAggregatedBy().equals("In charge officer")) {
                aggregationField = OFFICERINCHRGE;
            } else if (genericSubReport.getAggregatedBy().equals("Judgment outcome")) {
                aggregationField = JUDGEMENTOUTCOME;
            }
        }
        return aggregationField;
    }

    private BoolQueryBuilder getFilterQuery(LegalCommonReportResult searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"cityName", (String)ApplicationThreadLocals.getCityName()));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getOfficerIncharge())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)OFFICERINCHRGE, (String)searchRequest.getOfficerIncharge().split("@")[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseCategory())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)CASETYPE, (String)searchRequest.getCaseCategory()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCourtName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)COURTNAME, (String)searchRequest.getCourtName()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseStatus())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)CASESTATUS, (String)searchRequest.getCaseStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCourtType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)COURTTYPE, (String)searchRequest.getCourtType()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getPetitionType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)PETITIONTYPE, (String)searchRequest.getPetitionType()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getJudgmentType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)JUDGEMENTOUTCOME, (String)searchRequest.getJudgmentType()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getStandingCounsel())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"advocateName", (String)searchRequest.getStandingCounsel()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getReportStatus())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"subStatus", (String)searchRequest.getReportStatus()));
        }
        return boolQuery;
    }
}

