/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.lcms.transactions.entity.LegalCase;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_LEGALCASE_MISCDETAILS")
@SequenceGenerator(name="SEQ_EGLC_LEGALCASE_MISCDETAILS", sequenceName="SEQ_EGLC_LEGALCASE_MISCDETAILS", allocationSize=1)
public class LegalCaseMiscDetails
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_LEGALCASE_MISCDETAILS = "SEQ_EGLC_LEGALCASE_MISCDETAILS";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_LEGALCASE_MISCDETAILS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @Valid
    @JoinColumn(name="legalcase", nullable=false)
    private LegalCase legalCase;
    @Required(message="miscDetails.date.null")
    @DateFormat(message="invalid.fieldvalue.model.miscDate")
    private Date miscDate;
    @Length(max=50, message="miscDetails.referencenumber.maxlength")
    private String referenceNumber;
    @Length(max=1024, message="miscDetails.remarks.maxlength")
    private String remarks;
    @ManyToOne
    @NotNull
    @Valid
    @JoinColumn(name="STATUS", nullable=false)
    private EgwStatus status;

    public Date getMiscDate() {
        return this.miscDate;
    }

    public void setMiscDate(Date miscDate) {
        this.miscDate = miscDate;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }
}

