/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.eis.entity.Employee;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.masters.entity.InterimOrder;
import org.egov.lcms.transactions.entity.LcInterimOrderDocuments;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.VacateStay;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_LCINTERIMORDER")
@SequenceGenerator(name="SEQ_EGLC_LCINTERIMORDER", sequenceName="SEQ_EGLC_LCINTERIMORDER", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class LegalCaseInterimOrder
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_LCINTERIMORDER = "SEQ_EGLC_LCINTERIMORDER";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_LCINTERIMORDER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Valid
    @NotNull
    @JoinColumn(name="LEGALCASE", nullable=false)
    @ManyToOne
    @Audited
    private LegalCase legalCase;
    @Valid
    @NotNull
    @JoinColumn(name="interimorder", nullable=false)
    @ManyToOne
    @Audited
    private InterimOrder interimOrder;
    @Temporal(value=TemporalType.DATE)
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy")
    @NotNull
    @Column(name="iodate")
    @Audited
    private Date ioDate;
    @Length(max=50)
    @Column(name="mpnumber")
    @Audited
    private String mpNumber;
    @Length(max=1024)
    @Audited
    private String notes;
    @Temporal(value=TemporalType.DATE)
    @Column(name="sendtostandingcounsel")
    @Audited
    private Date sendtoStandingCounsel;
    @Temporal(value=TemporalType.DATE)
    @Column(name="petitionfiledon")
    private Date petitionFiledOn;
    @Temporal(value=TemporalType.DATE)
    @Column(name="reportfilingdue")
    @Audited
    private Date reportFilingDue;
    @Temporal(value=TemporalType.DATE)
    @Column(name="senttodepartment")
    @Audited
    private Date sendtoDepartment;
    @Temporal(value=TemporalType.DATE)
    @Column(name="reportfromhod")
    @Audited
    private Date reportFromHod;
    @Temporal(value=TemporalType.DATE)
    @Column(name="reportsendtostandingcounsel")
    @Audited
    private Date reportSendtoStandingCounsel;
    @Temporal(value=TemporalType.DATE)
    @Column(name="reportfilingdate")
    @Audited
    private Date reportFilingDate;
    @Length(max=50)
    @Audited
    private String referenceNumber;
    @Audited
    @Column(name="actionitem")
    private String actionItem;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="employee")
    @Audited
    private Employee employee;
    @Temporal(value=TemporalType.DATE)
    @Column(name="duedate")
    @Audited
    private Date dueDate;
    @Audited
    @Column(name="actiontaken")
    private String actionTaken;
    @OneToMany(mappedBy="legalCaseInterimOrder", fetch=FetchType.LAZY)
    @NotAudited
    private List<LcInterimOrderDocuments> lcInterimOrderDocuments = new ArrayList<LcInterimOrderDocuments>(0);
    @OneToMany(mappedBy="legalCaseInterimOrder", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Audited
    private List<VacateStay> vacateStay = new ArrayList<VacateStay>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public InterimOrder getInterimOrder() {
        return this.interimOrder;
    }

    public void setInterimOrder(InterimOrder interimOrder) {
        this.interimOrder = interimOrder;
    }

    public List<LcInterimOrderDocuments> getLcInterimOrderDocuments() {
        return this.lcInterimOrderDocuments;
    }

    public void setLcInterimOrderDocuments(List<LcInterimOrderDocuments> lcInterimOrderDocuments) {
        this.lcInterimOrderDocuments = lcInterimOrderDocuments;
    }

    public Date getIoDate() {
        return this.ioDate;
    }

    public void setIoDate(Date ioDate) {
        this.ioDate = ioDate;
    }

    public String getMpNumber() {
        return this.mpNumber;
    }

    public void setMpNumber(String mpNumber) {
        this.mpNumber = mpNumber;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Date getSendtoStandingCounsel() {
        return this.sendtoStandingCounsel;
    }

    public void setSendtoStandingCounsel(Date sendtoStandingCounsel) {
        this.sendtoStandingCounsel = sendtoStandingCounsel;
    }

    public Date getPetitionFiledOn() {
        return this.petitionFiledOn;
    }

    public void setPetitionFiledOn(Date petitionFiledOn) {
        this.petitionFiledOn = petitionFiledOn;
    }

    public Date getReportFilingDue() {
        return this.reportFilingDue;
    }

    public void setReportFilingDue(Date reportFilingDue) {
        this.reportFilingDue = reportFilingDue;
    }

    public Date getSendtoDepartment() {
        return this.sendtoDepartment;
    }

    public void setSendtoDepartment(Date sendtoDepartment) {
        this.sendtoDepartment = sendtoDepartment;
    }

    public Date getReportFromHod() {
        return this.reportFromHod;
    }

    public void setReportFromHod(Date reportFromHod) {
        this.reportFromHod = reportFromHod;
    }

    public Date getReportSendtoStandingCounsel() {
        return this.reportSendtoStandingCounsel;
    }

    public void setReportSendtoStandingCounsel(Date reportSendtoStandingCounsel) {
        this.reportSendtoStandingCounsel = reportSendtoStandingCounsel;
    }

    public Date getReportFilingDate() {
        return this.reportFilingDate;
    }

    public void setReportFilingDate(Date reportFilingDate) {
        this.reportFilingDate = reportFilingDate;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getInterimOrder() != null && this.getInterimOrder().getInterimOrderType().equals("Report File") && this.getReportFilingDue() == null) {
            errors.add(new ValidationError("reportFilingDue", "reportFilingDue.required"));
        }
        if (!DateUtils.compareDates((Date)this.getIoDate(), (Date)this.legalCase.getCaseDate())) {
            errors.add(new ValidationError("ioDate", "ioDate.greaterThan.caseDate"));
        }
        if (!DateUtils.compareDates((Date)this.getPetitionFiledOn(), (Date)this.getSendtoStandingCounsel())) {
            errors.add(new ValidationError("petitionFiledOn", "petitionFiledOn.greaterThan.sendtostandingcounsel"));
        }
        if (!DateUtils.compareDates((Date)this.getReportFilingDue(), (Date)this.getIoDate())) {
            errors.add(new ValidationError("iodate", "reportFilingDue.greaterThan.iodate"));
        }
        if (!DateUtils.compareDates((Date)this.getSendtoDepartment(), (Date)this.getIoDate())) {
            errors.add(new ValidationError("iodate", "sendtoDepartment.greaterThan.iodate"));
        }
        if (!DateUtils.compareDates((Date)this.getReportSendtoStandingCounsel(), (Date)this.getReportFromHod())) {
            errors.add(new ValidationError("reportFromHod", "reportFromHod.greaterThan.reportSendtoStandingCounsel"));
        }
        if (!DateUtils.compareDates((Date)this.getReportFilingDate(), (Date)this.getReportSendtoStandingCounsel())) {
            errors.add(new ValidationError("reportFilingDate", "reportSendtoStandingCounsel.greaterThan.reportFilingDate"));
        }
        return errors;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }

    public List<VacateStay> getVacateStay() {
        return this.vacateStay;
    }

    public void setVacateStay(List<VacateStay> vacateStay) {
        this.vacateStay = vacateStay;
    }

    public String getActionItem() {
        return this.actionItem;
    }

    public void setActionItem(String actionItem) {
        this.actionItem = actionItem;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getActionTaken() {
        return this.actionTaken;
    }

    public void setActionTaken(String actionTaken) {
        this.actionTaken = actionTaken;
    }
}

